/*******************************************************************************
 * Copyright (c) 2000, 2017 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Image;

/**
 * Implementation of the <code>IContextInformation</code> interface.
 */
public class ProposalContextInformation implements IContextInformation, IContextInformationExtension {

	private final String fContextDisplayString;
	private final String fInformationDisplayString;
	private final Image fImage;
	private int fPosition;

	/**
	 * Creates a new context information.
	 */
	public ProposalContextInformation(CompletionProposal proposal) {
		// don't cache the core proposal because the ContentAssistant might
		// hang on to the context info.
		// TODO REVIEW THIS
		String res = createParametersList(proposal);
		fInformationDisplayString = res;// labelProvider.createParameterList(proposal);
		// ImageDescriptor descriptor=
		// labelProvider.createImageDescriptor(proposal);
		// if (descriptor != null)
		// fImage= JavaPlugin.getImageDescriptorRegistry().get(descriptor);
		// else
		fImage = null;
		if (proposal.getCompletion().length() == 0)
			fPosition = proposal.getCompletionLocation();
		else
			fPosition = -1;
		fContextDisplayString = res;// labelProvider.createLabel(proposal);
	}

	private String createParametersList(CompletionProposal proposal) {
		StringBuilder bf = new StringBuilder();
		String[] pNames = proposal.getParameterNames();
		if (pNames != null) {
			for (int a = 0; a < pNames.length; a++) {
				bf.append(pNames[a]);
				if (a != pNames.length - 1)
					bf.append(',');
			}
		}
		return bf.toString();
	}

	@Override
	public boolean equals(Object object) {
		if (object instanceof IContextInformation) {
			IContextInformation contextInformation = (IContextInformation) object;
			boolean equals = getInformationDisplayString()
					.equalsIgnoreCase(contextInformation.getInformationDisplayString());
			if (getContextDisplayString() != null)
				equals = equals
						&& getContextDisplayString().equalsIgnoreCase(contextInformation.getContextDisplayString());
			return equals;
		}
		return false;
	}

	@Override
	public String getInformationDisplayString() {
		return fInformationDisplayString;
	}

	@Override
	public Image getImage() {
		return fImage;
	}

	@Override
	public String getContextDisplayString() {
		return fContextDisplayString;
	}

	@Override
	public int getContextInformationPosition() {
		return fPosition;
	}

	/**
	 * Sets the context information position.
	 *
	 * @param position the new position, or -1 for unknown.
	 */
	public void setContextInformationPosition(int position) {
		fPosition = position;
	}
}
