/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.JDTBeanMethod;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.context.symbol.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanPropertySymbol;

public class JavaUtil {
    private JavaUtil() {
    }

    public static String getMethodJavadoc(IMethod method) {
        try {
            Reader contentReader = JavadocContentAccess.getHTMLContentReader((IMember)method, (boolean)true, (boolean)true);
            if (contentReader != null) {
                return JavaUtil.read(contentReader);
            }
        }
        catch (JavaModelException e) {
            JSFCommonPlugin.log(2, "error reading javadoc for method '" + method.getElementName() + "'.", e);
        }
        return null;
    }

    private static String read(Reader rd) {
        StringBuffer buffer = new StringBuffer();
        char[] readBuffer = new char[2048];
        try {
            int n = rd.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = rd.read(readBuffer);
            }
            return buffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static IMethod findCorrespondingMethod(IBeanMethodSymbol symbol) {
        JDTBeanMethod[] methods;
        IType type = symbol.getOwner().getType();
        JDTBeanIntrospector introspector = JDTBeanIntrospector.forType(type);
        JDTBeanMethod[] jDTBeanMethodArray = methods = introspector.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String currentMethodsSignature;
            JDTBeanMethod method = jDTBeanMethodArray[n2];
            if (method.getElementName().equals(symbol.getName()) && (currentMethodsSignature = method.getResolvedSignatureErased()).equals(symbol.getSignature())) {
                return method.getMethod();
            }
            ++n2;
        }
        return null;
    }

    public static JDTBeanProperty findCorrespondingJDTProperty(IBeanPropertySymbol propertySymbol) {
        JDTBeanIntrospector introspector = JDTBeanIntrospector.forType(propertySymbol.getOwner().getType());
        return introspector.getProperties().get(propertySymbol.getName());
    }
}

