/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.util.Collection;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IContextQuery;

public class ContextQueryProxy
implements IContextQuery {
    private final IChannel channel;

    public ContextQueryProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public String getName() {
        return "ContextQuery";
    }

    @Override
    public IToken query(String query, final IContextQuery.DoneQuery done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"query", (Object[])new Object[]{query}){

            @Override
            public void done(Exception error, Object[] args) {
                String[] contexts = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    contexts = ContextQueryProxy.this.toStringArray(args[1]);
                }
                done.doneQuery(this.token, error, contexts);
            }
        }.token;
    }

    @Override
    public IToken getAttrNames(final IContextQuery.DoneGetAttrNames done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getAttrNames", null){

            @Override
            public void done(Exception error, Object[] args) {
                String[] names = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    names = ContextQueryProxy.this.toStringArray(args[1]);
                }
                done.doneGetAttrNames(this.token, error, names);
            }
        }.token;
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }
}

