/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.launcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.launcher.TestViewSupportExtension;
import org.eclipse.unittest.ui.ITestViewSupport;

public class TestViewSupportRegistry {
    public static final String ID_EXTENSION_POINT_TEST_VIEW_SUPPORTS = "org.eclipse.unittest.ui.unittestViewSupport";
    private static TestViewSupportRegistry fgRegistry;
    private final IExtensionPoint fPoint;
    private List<TestViewSupportExtension> fTestViewSupportExtensions;

    public static TestViewSupportRegistry getDefault() {
        if (fgRegistry != null) {
            return fgRegistry;
        }
        fgRegistry = new TestViewSupportRegistry(Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_TEST_VIEW_SUPPORTS));
        return fgRegistry;
    }

    private TestViewSupportRegistry(IExtensionPoint point) {
        this.fPoint = point;
    }

    private List<TestViewSupportExtension> getAllTestViewSupportExtensions() {
        this.loadTestViewSupportExtensions();
        return this.fTestViewSupportExtensions;
    }

    public List<TestViewSupportExtension> getTestViewSupportExtensions(String filter) {
        List<TestViewSupportExtension> all = this.getAllTestViewSupportExtensions();
        if (all == null) {
            return Collections.emptyList();
        }
        return all.stream().filter(p -> p.getId().startsWith(filter)).collect(Collectors.toList());
    }

    private void loadTestViewSupportExtensions() {
        if (this.fTestViewSupportExtensions != null) {
            return;
        }
        List items = this.getConfigurationElements().stream().map(TestViewSupportExtension::new).collect(Collectors.toList());
        this.fTestViewSupportExtensions = items;
    }

    private Optional<ITestViewSupport> findTestViewSupport(String id) {
        return this.getAllTestViewSupportExtensions().stream().filter(ext -> ext.getId().equals(id)).findFirst().map(t -> {
            try {
                return t.instantiateTestViewSupport();
            }
            catch (CoreException e) {
                UnitTestPlugin.log(e);
                return null;
            }
        });
    }

    public static Optional<ITestViewSupport> newTestRunnerViewSupport(ILaunchConfiguration launchConfiguration) {
        try {
            return TestViewSupportRegistry.getDefault().findTestViewSupport(launchConfiguration.getAttribute("org.eclipse.unittest.ui.TEST_VIEW_SUPPPORT", null));
        }
        catch (CoreException e) {
            UnitTestPlugin.log(e);
            return Optional.empty();
        }
    }

    private List<IConfigurationElement> getConfigurationElements() {
        ArrayList<IConfigurationElement> items = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = this.fPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            Collections.addAll(items, extension.getConfigurationElements());
            ++n2;
        }
        return items;
    }
}

