/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wb.core.gef.command.CompoundEditCommand;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.editor.actions.ActionUtils;

public class DeleteAction
extends Action {
    private final IEditPartViewer m_viewer;
    private Command m_command;

    public DeleteAction(IEditPartViewer viewer) {
        this.m_viewer = viewer;
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DeleteAction.this.firePropertyChange("enabled", null, DeleteAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
            }
        });
        ActionUtils.copyPresentation((IAction)this, ActionFactory.DELETE);
    }

    public void run() {
        this.m_viewer.getEditDomain().executeCommand(this.m_command);
    }

    public boolean isEnabled() {
        this.m_command = DeleteAction.getCommand(this.m_viewer.getSelectedEditParts());
        return this.m_command != null;
    }

    public static Command getCommand(List<EditPart> editParts) {
        if (editParts.isEmpty()) {
            return null;
        }
        ArrayList<ObjectInfo> objects = new ArrayList<ObjectInfo>();
        for (EditPart editPart : editParts) {
            Object model = editPart.getModel();
            if (!(model instanceof ObjectInfo)) {
                return null;
            }
            ObjectInfo object = (ObjectInfo)model;
            if (object.isDeleted()) {
                return null;
            }
            if (!object.canDelete()) {
                return null;
            }
            objects.add(object);
        }
        Iterator I = objects.iterator();
        while (I.hasNext()) {
            final ObjectInfo object = (ObjectInfo)I.next();
            if (object.getParent(objects) == null) continue;
            I.remove();
        }
        CompoundEditCommand command = new CompoundEditCommand((ObjectInfo)objects.get(0));
        for (final ObjectInfo object : objects) {
            command.add(new EditCommand(object){

                @Override
                protected void executeEdit() throws Exception {
                    object.delete();
                }
            });
        }
        return command;
    }
}

