/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Optional;
import org.eclipse.cdt.codan.core.cxx.model.AbstractAstFunctionChecker;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCastExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.resources.IResource;

public class NoDiscardChecker
extends AbstractAstFunctionChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.NoDiscardProblem";
    public static final String PARAM_MACRO_ID = "macro";

    protected void processFunction(IASTFunctionDefinition func) {
        func.accept((ASTVisitor)new FunctionCallVisitor());
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_MACRO_ID, CheckersMessages.NoDiscardChecker_ParameterMacro, Boolean.TRUE);
    }

    private boolean shouldReportInMacro() {
        return (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_MACRO_ID);
    }

    class FunctionCallVisitor
    extends ASTVisitor {
        FunctionCallVisitor() {
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTExpression expr) {
            Optional<IASTNode> res;
            if (!NoDiscardChecker.this.shouldReportInMacro() && NoDiscardChecker.enclosedInMacroExpansion((IASTNode)((IASTNode)expr))) {
                return 1;
            }
            if (this.isDiscardedValueExpression(expr) && (res = this.getNodiscardFunction(expr)).isPresent()) {
                NoDiscardChecker.this.reportProblem(NoDiscardChecker.ER_ID, (IASTNode)expr, new Object[]{res.get()});
            }
            return 3;
        }

        private boolean isDiscardedValueExpression(IASTExpression expr) {
            IASTNode parent = expr.getParent();
            IASTExpression child = expr;
            while (parent instanceof IASTUnaryExpression) {
                int operator = ((IASTUnaryExpression)parent).getOperator();
                if (operator != 11) {
                    return false;
                }
                child = parent;
                parent = parent.getParent();
            }
            if (parent instanceof IASTExpressionStatement) {
                return true;
            }
            return child instanceof IASTExpression && this.checkNestedLeftSide(child);
        }

        private Optional<IASTNode> getNodiscardFunction(IASTExpression expr) {
            if (expr instanceof IASTFunctionCallExpression) {
                IASTName name;
                IASTFunctionCallExpression func = (IASTFunctionCallExpression)expr;
                IASTExpression functionNameExpression = func.getFunctionNameExpression();
                if (functionNameExpression instanceof IASTIdExpression) {
                    name = ((IASTIdExpression)functionNameExpression).getName();
                } else if (functionNameExpression instanceof IASTFieldReference) {
                    name = ((IASTFieldReference)functionNameExpression).getFieldName();
                } else {
                    return Optional.empty();
                }
                if (expr instanceof ICPPASTExpression) {
                    if (this.checkEvaluation((ICPPASTExpression)expr)) {
                        return Optional.of(name);
                    }
                    return Optional.empty();
                }
                IBinding binding = name.resolveBinding();
                if (binding instanceof IFunction && ((IFunction)binding).isNoDiscard()) {
                    return Optional.of(name);
                }
                return Optional.empty();
            }
            if (expr instanceof ICPPASTCastExpression) {
                ICPPASTCastExpression cast = (ICPPASTCastExpression)expr;
                if (cast.getOperator() != 2) {
                    return Optional.empty();
                }
                if (this.checkEvaluation((ICPPASTExpression)cast)) {
                    return Optional.of(cast.getTypeId());
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        private boolean checkEvaluation(ICPPASTExpression expr) {
            ICPPEvaluation eval = expr.getEvaluation();
            if (eval instanceof EvalTypeId) {
                ICPPFunction evalFunc = ((EvalTypeId)eval).getConstructor();
                if (evalFunc != null && evalFunc.isNoDiscard()) {
                    return true;
                }
            } else if (eval instanceof EvalFunctionCall) {
                ICPPFunction evalFunc = ((EvalFunctionCall)eval).resolveFunctionBinding();
                if (evalFunc == null) {
                    return false;
                }
                if (evalFunc.isNoDiscard()) {
                    return true;
                }
                ICPPFunctionType fType = evalFunc.getType();
                IType retType = SemanticUtil.getNestedType((IType)fType.getReturnType(), (int)1);
                if (CPPTemplates.isDependentType((IType)retType)) {
                    return false;
                }
                if (retType instanceof ICPPReferenceType || retType instanceof IPointerType) {
                    return false;
                }
                if ((retType = SemanticUtil.getUltimateType((IType)retType, (boolean)true)) instanceof ICPPClassType) {
                    return ((ICPPClassType)retType).isNoDiscard();
                }
                if (retType instanceof ICPPEnumeration) {
                    return ((ICPPEnumeration)retType).isNoDiscard();
                }
            }
            return false;
        }

        private boolean checkNestedLeftSide(IASTExpression expr) {
            IASTExpressionList list;
            IASTExpression[] allExpr;
            return expr.getPropertyInParent() == IASTExpressionList.NESTED_EXPRESSION && expr != (allExpr = (list = (IASTExpressionList)expr.getParent()).getExpressions())[allExpr.length - 1];
        }
    }
}

