/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.derby.internal.ui.connection.drivers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.apache.derby.internal.ui.connection.drivers.Messages;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.connectivity.ui.wizards.OptionalPropertiesPane;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class DerbyDriverUIContributor
implements IDriverUIContributor,
Listener {
    protected String CUI_NEWCW_DATABASE_LBL_UI_ = Messages.getString("CUI_NEWCW_DATABASE_LBL_UI_");
    private static final String CUI_NEWCW_HOST_LBL_UI_ = Messages.getString("CUI_NEWCW_HOST_LBL_UI_");
    private static final String CUI_NEWCW_PORT_LBL_UI_ = Messages.getString("CUI_NEWCW_PORT_LBL_UI_");
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = Messages.getString("CUI_NEWCW_CONNECTIONURL_LBL_UI_");
    private static final String CUI_NEWCW_USERNAME_LBL_UI_ = Messages.getString("CUI_NEWCW_USERNAME_LBL_UI_");
    private static final String CUI_NEWCW_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_CREATEDB_BTN_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.2");
    private static final String CUI_NEWCW_UPGRADEDB_BTN_UI_ = Messages.getString("DerbyEmbeddedDriverUIContributor.3");
    private static final String CUI_NEWCW_SAVE_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_URL_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_URL_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_CREATE_DATABASE_SUMMARY_DATA_TEXT_ = TextProcessor.process((String)Messages.getString("CUI_NEWCW_CREATE_DATABASE_SUMMARY_DATA_TEXT_"));
    private static final String CUI_NEWCW_UPGRADE_DATABASE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_UPGRADE_DATABASE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_");
    private static final String CREATE_EQUALS_TRUE_TEXT = "create=true";
    private static final String UPGRADE_EQUALS_TRUE_TEXT = "upgrade=true";
    private Label databaseLabel;
    private Text databaseText;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Text portText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button createCheck;
    private Button upgradeCheck;
    private Button savePasswordButton;
    private Label urlLabel;
    private Text urlText;
    private DialogPage parentPage;
    private ScrolledComposite parentComposite;
    private OptionalPropertiesPane optionalPropsComposite;
    private IDriverUIContributorInformation contributorInformation;
    private Properties properties;
    private boolean isReadOnly = false;

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            TabFolder tabComposite = new TabFolder((Composite)this.parentComposite, 128);
            TabItem generalTab = new TabItem(tabComposite, 0);
            generalTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.generaltab"));
            Composite baseComposite = new Composite((Composite)tabComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            baseComposite.setLayout((Layout)layout);
            generalTab.setControl((Control)baseComposite);
            this.databaseLabel = new Label(baseComposite, 0);
            this.databaseLabel.setText(this.CUI_NEWCW_DATABASE_LBL_UI_);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            this.databaseLabel.setLayoutData((Object)gd);
            this.databaseText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.databaseText.setLayoutData((Object)gd);
            this.hostLabel = new Label(baseComposite, 0);
            this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.portLabel = new Label(baseComposite, 0);
            this.portLabel.setText(CUI_NEWCW_PORT_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.portLabel.setLayoutData((Object)gd);
            this.portText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.portText.setLayoutData((Object)gd);
            this.usernameLabel = new Label(baseComposite, 0);
            this.usernameLabel.setText(CUI_NEWCW_USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.usernameLabel.setLayoutData((Object)gd);
            this.usernameText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.usernameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(baseComposite, 0);
            this.passwordLabel.setText(CUI_NEWCW_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(baseComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.createCheck = new Button(baseComposite, 32);
            this.createCheck.setText(CUI_NEWCW_CREATEDB_BTN_UI_);
            this.createCheck.setSelection(true);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.createCheck.setLayoutData((Object)gd);
            this.upgradeCheck = new Button(baseComposite, 32);
            this.upgradeCheck.setText(CUI_NEWCW_UPGRADEDB_BTN_UI_);
            this.upgradeCheck.setSelection(false);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.upgradeCheck.setLayoutData((Object)gd);
            this.savePasswordButton = new Button(baseComposite, 32);
            this.savePasswordButton.setText(CUI_NEWCW_SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.urlLabel = new Label(baseComposite, 0);
            this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(baseComposite, 2634);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            gd.widthHint = 190;
            gd.heightHint = 90;
            this.urlText.setLayoutData((Object)gd);
            TabItem optionalPropsTab = new TabItem(tabComposite, 0);
            optionalPropsTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.optionaltab"));
            this.optionalPropsComposite = new OptionalPropertiesPane((Composite)tabComposite, 0, isReadOnly);
            optionalPropsTab.setControl((Control)this.optionalPropsComposite);
            this.parentComposite.setContent((Control)tabComposite);
            this.parentComposite.setMinSize(tabComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    public void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.databaseText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.optionalPropsComposite.setConnectionInformation();
        this.contributorInformation.setProperties(this.properties);
    }

    public void updateURL() {
        String url = "jdbc:derby:net://" + this.hostText.getText().trim();
        if (this.portText.getText().trim().length() > 0) {
            url = String.valueOf(url) + ":" + this.portText.getText().trim();
        }
        url = String.valueOf(url) + "/" + this.databaseText.getText().trim() + ":retrieveMessagesFromServerOnGetMessage=true;";
        if (this.createCheck.getSelection()) {
            url = String.valueOf(url) + "create=true;";
        }
        if (this.upgradeCheck.getSelection()) {
            url = String.valueOf(url) + "upgrade=true;";
        }
        this.urlText.setText(url);
    }

    private void removeListeners() {
        this.databaseText.removeListener(24, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.portText.removeListener(24, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.createCheck.removeListener(13, (Listener)this);
        this.upgradeCheck.removeListener(13, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
    }

    private void addListeners() {
        this.databaseText.addListener(24, (Listener)this);
        this.hostText.addListener(24, (Listener)this);
        this.portText.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.createCheck.addListener(13, (Listener)this);
        this.upgradeCheck.addListener(13, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            } else if (event.widget == this.createCheck) {
                this.createCheck.setSelection(!this.createCheck.getSelection());
            } else if (event.widget == this.upgradeCheck) {
                this.upgradeCheck.setSelection(!this.upgradeCheck.getSelection());
            }
        } else {
            this.updateURL();
            this.setConnectionInformation();
        }
    }

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.databaseText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(MessageFormat.format(Messages.getString("CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_"), Messages.getString("CUI_NEWCW_DEFDBNAME_VAL_UI_")));
            isComplete = false;
        } else if (this.hostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_HOST_REQ_UI_"));
            isComplete = false;
        } else if (this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_USERID_REQ_UI_"));
            isComplete = false;
        } else if (this.passwordText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_PASSWORD_REQ_UI_"));
            isComplete = false;
        } else if (!this.optionalPropsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
        this.optionalPropsComposite.setDriverUIContributorInformation(contributorInformation);
    }

    public void loadProperties() {
        String savePassword;
        String password;
        this.removeListeners();
        DerbyJDBCURL url = new DerbyJDBCURL(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.hostText.setText(url.getNode());
        this.portText.setText(url.getPort());
        this.databaseText.setText(url.getDatabaseName());
        String username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (username != null) {
            this.usernameText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.passwordText.setText(password);
        }
        if (url.getProperties().indexOf(CREATE_EQUALS_TRUE_TEXT) <= -1) {
            this.createCheck.setSelection(false);
        }
        if (url.getProperties().indexOf(UPGRADE_EQUALS_TRUE_TEXT) > -1) {
            this.upgradeCheck.setSelection(true);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        this.optionalPropsComposite.loadProperties();
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_, this.databaseText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_, this.portText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_CREATE_DATABASE_SUMMARY_DATA_TEXT_, this.createCheck.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_UPGRADE_DATABASE_SUMMARY_DATA_TEXT_, this.upgradeCheck.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        return summaryData;
    }

    private class DerbyJDBCURL {
        private String subprotocol = "";
        private String node = "";
        private String port = "";
        private String databaseName = "";
        private String properties = "";

        public DerbyJDBCURL(String url) {
            if (url != null) {
                this.parseURL(url);
            }
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        private void parseURL(String url) {
            try {
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                this.subprotocol = String.valueOf(this.subprotocol) + ":" + remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 3);
                this.node = remainingURL.substring(0, remainingURL.indexOf(47));
                if (this.node.indexOf(58) > -1) {
                    this.port = this.node.substring(this.node.indexOf(58) + 1);
                    this.node = this.node.substring(0, this.node.indexOf(58));
                }
                if ((remainingURL = remainingURL.substring(remainingURL.indexOf(47) + 1)).indexOf(34) > -1) {
                    remainingURL = remainingURL.substring(remainingURL.indexOf(34) + 1);
                    this.databaseName = "\"" + remainingURL.substring(0, remainingURL.indexOf(34) + 1);
                    this.properties = remainingURL = remainingURL.substring(remainingURL.indexOf(34) + 2);
                } else if (remainingURL.indexOf(58) > -1) {
                    this.databaseName = remainingURL.substring(0, remainingURL.indexOf(58));
                    this.properties = remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                } else {
                    this.databaseName = remainingURL;
                }
            }
            catch (Exception exception) {}
        }

        public String getPort() {
            return this.port;
        }

        public String getProperties() {
            return this.properties;
        }
    }
}

