/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;

class BuildResultCollector
implements IIncrementalBuildFramework.BuildResultCollector {
    private String currentParticipantId;
    private final Set<File> refresh = new HashSet<File>();
    private final Map<String, List<Message>> messages = new LinkedHashMap<String, List<Message>>();
    private final Map<String, List<File>> removeMessages = new LinkedHashMap<String, List<File>>();

    BuildResultCollector() {
    }

    @Override
    public Set<File> getFiles() {
        return this.refresh;
    }

    @Override
    public void refresh(File file) {
        this.refresh.add(file);
    }

    @Override
    public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        if (this.currentParticipantId == null) {
            throw new IllegalStateException("currentBuildParticipantId cannot be null or empty");
        }
        List messageList = this.messages.computeIfAbsent(this.currentParticipantId, i -> new ArrayList());
        messageList.add(new Message(file, line, column, message, severity, cause));
    }

    @Override
    public void removeMessages(File file) {
        if (this.currentParticipantId == null) {
            throw new IllegalStateException("currentBuildParticipantId cannot be null or empty");
        }
        List files = this.removeMessages.computeIfAbsent(this.currentParticipantId, i -> new ArrayList());
        files.add(file);
    }

    public Map<String, List<Message>> getMessages() {
        return this.messages;
    }

    public Map<String, List<File>> getRemoveMessages() {
        return this.removeMessages;
    }

    public void setParticipantId(String participantId) {
        this.currentParticipantId = participantId;
    }

    public record Message(File file, int line, int column, String message, int severity, Throwable cause) {
        public Message {
            if (message == null && cause != null) {
                message = cause.getMessage();
            }
        }
    }
}

