/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests.inspection;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.inspection.EnvironmentProperty;
import org.eclipse.passage.lic.api.inspection.RuntimeEnvironment;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class RuntimeEnvironmentContractTest {
    @Test
    public void isDedicatedToProperEvaluationType() {
        Assert.assertEquals((Object)this.expectedEvaluationType(), (Object)this.environment().id());
    }

    @Test
    public void inspects() {
        try {
            Assert.assertFalse((boolean)this.environment().isAssuptionTrue(this.property(), this.invalidPropertyValue()));
        }
        catch (LicensingException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test(expected=NullPointerException.class)
    public void doesNotInspectNullProperty() {
        try {
            this.environment().isAssuptionTrue(null, "none");
        }
        catch (LicensingException licensingException) {
            Assert.fail((String)"No insection activity is intended to be triggered for invalid input data");
        }
    }

    @Test(expected=NullPointerException.class)
    public void doesNotInspectForNullValue() {
        try {
            this.environment().isAssuptionTrue(this.property(), null);
        }
        catch (LicensingException licensingException) {
            Assert.fail((String)"No insection activity is intended to be triggered for invalid input data");
        }
    }

    @Test
    public void knowsSimpleRegexp() {
        try {
            Assert.assertTrue((boolean)this.environment().isAssuptionTrue(this.property(), "*"));
        }
        catch (LicensingException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test
    public void depictsState() {
        try {
            String state = this.environment().state();
            Assert.assertNotNull((Object)state);
            Assert.assertFalse((boolean)state.trim().isEmpty());
        }
        catch (LicensingException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test
    public void standsSimultaneousRequests() {
        RuntimeEnvironment environment = this.environment();
        int threads = 128;
        CountDownLatch readySteadyGo = new CountDownLatch(1);
        CountDownLatch done = new CountDownLatch(threads);
        List demands = IntStream.range(0, threads).mapToObj(no -> new InspectionDemand(environment, readySteadyGo, done)).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        demands.stream().forEach(executor::execute);
        try {
            Thread.sleep(2000L);
            readySteadyGo.countDown();
            done.await();
        }
        catch (InterruptedException e) {
            Assume.assumeNoException((Throwable)e);
        }
        Assert.assertTrue((boolean)demands.stream().filter(InspectionDemand::notSkipped).allMatch(InspectionDemand::result));
    }

    protected abstract RuntimeEnvironment environment();

    protected abstract EvaluationType expectedEvaluationType();

    protected abstract String invalidPropertyValue();

    protected abstract EnvironmentProperty property();

    private final class InspectionDemand
    implements Runnable {
        private final CountDownLatch altogether;
        private final CountDownLatch done;
        private final RuntimeEnvironment env;
        private boolean result = false;
        private boolean skip = false;

        InspectionDemand(RuntimeEnvironment env, CountDownLatch altogether, CountDownLatch done) {
            this.env = env;
            this.altogether = altogether;
            this.done = done;
        }

        @Override
        public void run() {
            try {
                this.altogether.await();
                this.ask();
                this.done.countDown();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        private void ask() {
            try {
                this.result = !this.env.isAssuptionTrue(RuntimeEnvironmentContractTest.this.property(), RuntimeEnvironmentContractTest.this.invalidPropertyValue());
            }
            catch (Exception exception) {
                this.skip = true;
            }
        }

        boolean result() {
            return this.result;
        }

        boolean notSkipped() {
            return !this.skip;
        }
    }
}

