/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text;

import org.eclipse.dltk.compiler.env.ISourceType;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.PHPSelectionUtil;
import org.eclipse.ui.IEditorPart;

public class PHPInformationHierarchyProvider
implements IInformationProvider,
IInformationProviderExtension {
    private PHPStructuredEditor fEditor;
    private boolean fUseCodeResolve = false;

    public PHPInformationHierarchyProvider(IEditorPart editor) {
        if (editor instanceof PHPStructuredEditor) {
            this.fEditor = (PHPStructuredEditor)editor;
        }
    }

    public PHPInformationHierarchyProvider(IEditorPart editor, boolean useCodeResolve) {
        this(editor);
        this.fUseCodeResolve = useCodeResolve;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null && this.fEditor != null) {
            IRegion region = ScriptWordFinder.findWord((IDocument)textViewer.getDocument(), (int)offset);
            if (region != null) {
                return region;
            }
            return new Region(offset, 0);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return this.getInformation2(textViewer, subject).toString();
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        IModelElement inputModelElement;
        if (this.fEditor == null) {
            return null;
        }
        if (this.fUseCodeResolve && (inputModelElement = this.fEditor.getModelElement()) instanceof ISourceModule && subject != null) {
            ISourceModule sourceModule = (ISourceModule)inputModelElement;
            IModelElement modelElement = PHPSelectionUtil.getSelectionModelElement(subject.getOffset(), subject.getLength(), sourceModule);
            if (modelElement != null) {
                if (modelElement instanceof ISourceType) {
                    return modelElement;
                }
                if (modelElement instanceof IMember) {
                    return modelElement;
                }
            } else {
                return null;
            }
        }
        return EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)false);
    }
}

