/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.log.core.internal.listener;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventFireDelegate;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.core.events.ChannelEvent;
import org.eclipse.tcf.te.tcf.log.core.internal.listener.ChannelTraceListenerManager;
import org.eclipse.tcf.te.tcf.log.core.manager.LogManager;

public final class EventListener
extends PlatformObject
implements IEventListener,
IEventFireDelegate {
    public void fire(Runnable runnable) {
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    public void eventFired(EventObject event) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (event instanceof ChannelEvent) {
            String logname;
            IChannel channel = ((ChannelEvent)event).getChannel();
            String type = ((ChannelEvent)event).getType();
            IPropertiesContainer data = ((ChannelEvent)event).getData();
            final String message = data != null ? data.getStringProperty("message") : null;
            String string = logname = data != null ? data.getStringProperty("logname") : null;
            if (logname != null) {
                logname = LogManager.getInstance().makeValid(logname);
            }
            if ("opening".equals(type)) {
                ChannelTraceListenerManager.getInstance().onChannelOpening(logname, channel, message);
            } else if ("redirect".equals(type)) {
                ChannelTraceListenerManager.getInstance().onChannelRedirected(logname, channel, message);
            } else if ("open".equals(type)) {
                ChannelTraceListenerManager.getInstance().onChannelOpened(logname, channel, message);
            } else if ("close".equals(type)) {
                ChannelTraceListenerManager.getInstance().onChannelClosed(logname, channel);
            } else if ("mark".equals(type)) {
                ChannelTraceListenerManager.getInstance().onMark(logname, channel, message);
            } else if ("closeWriter".equals(type)) {
                final IPeer peer = channel.getRemotePeer();
                if (peer != null) {
                    final String lognameFinal = logname;
                    ExecutorsUtil.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LogManager.getInstance().closeWriter(lognameFinal, peer, message);
                        }
                    });
                }
            } else if ("services".equals(type)) {
                ChannelTraceListenerManager.getInstance().onChannelServices(logname, channel, message);
            }
        }
    }
}

