/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Objects;
import java.util.function.IntSupplier;

public class CharsInputStream
extends InputStream {
    public static final char UNICODE_REPLACEMENT_CHAR = '\ufffd';
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private static final int EOF = -1;
    private final int bufferSize;
    private final CharBuffer charBuffer;
    private final ByteBuffer byteBuffer;
    private final CharsetEncoder encoder;
    private EncoderState encoderState = EncoderState.ENCODING;
    private int charIndex = 0;
    private final CharsSupplier chars;
    private final IntSupplier charsLength;

    public CharsInputStream(CharSequence chars) {
        this(chars, Charset.defaultCharset());
    }

    public CharsInputStream(CharSequence chars, Charset charset) {
        this(chars, charset, 512);
    }

    public CharsInputStream(CharSequence chars, Charset charset, int bufferSize) {
        this(chars::charAt, chars::length, charset, bufferSize);
    }

    public CharsInputStream(CharsSupplier chars, IntSupplier charsLength) {
        this(chars, charsLength, Charset.defaultCharset());
    }

    CharsInputStream(CharsSupplier chars, IntSupplier charsLength, Charset charset) {
        this(chars, charsLength, charset, 512);
    }

    public CharsInputStream(CharsSupplier chars, IntSupplier charsLength, Charset charset, int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("[bufferSize] must be 1 or larger");
        }
        this.encoder = charset.newEncoder();
        this.bufferSize = bufferSize;
        this.charBuffer = CharBuffer.allocate(bufferSize * 2);
        this.byteBuffer = ByteBuffer.allocate(bufferSize * 4);
        this.byteBuffer.flip();
        this.charBuffer.flip();
        this.chars = chars;
        this.charsLength = charsLength;
    }

    @Override
    public int available() {
        int remaining = this.byteBuffer.remaining();
        return remaining == 0 ? this.charsLength.getAsInt() - this.charIndex : remaining;
    }

    private void encodeChars(CharBuffer in, boolean isEndOfInput) throws CharacterCodingException {
        this.byteBuffer.clear();
        CoderResult result = this.encoder.encode(in, this.byteBuffer, isEndOfInput);
        this.byteBuffer.flip();
        if (result.isError()) {
            result.throwException();
        }
    }

    private boolean flushEncoder() throws IOException {
        if (this.encoderState == EncoderState.DONE) {
            return false;
        }
        if (this.encoderState == EncoderState.ENCODING) {
            this.encoderState = EncoderState.FLUSHING;
        }
        this.byteBuffer.clear();
        CoderResult result = this.encoder.flush(this.byteBuffer);
        this.byteBuffer.flip();
        if (result.isOverflow()) {
            return true;
        }
        if (result.isError()) {
            result.throwException();
        }
        this.encoderState = EncoderState.DONE;
        return this.byteBuffer.hasRemaining();
    }

    public Charset getCharset() {
        return this.encoder.charset();
    }

    @Override
    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining() && !this.refillByteBuffer()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int bytesToRead) throws IOException {
        Objects.checkFromIndexSize(off, bytesToRead, buf.length);
        if (bytesToRead == 0) {
            return 0;
        }
        int bytesRead = 0;
        int bytesReadable = this.byteBuffer.remaining();
        while (bytesRead < bytesToRead) {
            if (bytesReadable == 0) {
                if (this.refillByteBuffer()) {
                    bytesReadable = this.byteBuffer.remaining();
                } else {
                    return bytesRead == 0 ? -1 : bytesRead;
                }
            }
            int bytesToReadNow = Math.min(bytesToRead - bytesRead, bytesReadable);
            this.byteBuffer.get(buf, off + bytesRead, bytesToReadNow);
            bytesRead += bytesToReadNow;
            bytesReadable -= bytesToReadNow;
        }
        return bytesRead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean refillByteBuffer() throws IOException {
        if (this.encoderState == EncoderState.DONE) {
            return false;
        }
        if (this.encoderState == EncoderState.FLUSHING) {
            return this.flushEncoder();
        }
        int charsLen = this.charsLength.getAsInt();
        if (this.charIndex >= charsLen) {
            this.encodeChars(CharBuffer.allocate(0), true);
            return this.flushEncoder();
        }
        try {
            this.charBuffer.clear();
            int i = 0;
            while (i < this.bufferSize && this.charIndex < charsLen) {
                block10: {
                    char nextChar;
                    block11: {
                        if (!Character.isHighSurrogate(nextChar = this.chars.charAt(this.charIndex++))) break block11;
                        if (this.charIndex < charsLen) {
                            char lowSurrogate = this.chars.charAt(this.charIndex);
                            if (Character.isLowSurrogate(lowSurrogate)) {
                                ++this.charIndex;
                                this.charBuffer.put(nextChar);
                                this.charBuffer.put(lowSurrogate);
                                break block10;
                            } else {
                                this.charBuffer.put('\ufffd');
                            }
                            break block10;
                        } else {
                            this.charBuffer.put('\ufffd');
                            break;
                        }
                    }
                    this.charBuffer.put(nextChar);
                }
                ++i;
            }
            this.charBuffer.flip();
            this.encodeChars(this.charBuffer, false);
            return true;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @FunctionalInterface
    public static interface CharsSupplier {
        public char charAt(int var1) throws Exception;
    }

    private static enum EncoderState {
        ENCODING,
        FLUSHING,
        DONE;

    }
}

