/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.parserz;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.css.core.internal.parser.CSSTokenizer;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;

public class CSSTextParser {
    public static final int MODE_STYLESHEET = 0;
    public static final int MODE_DECLARATION = 1;
    public static final int MODE_DECLARATION_VALUE = 2;
    private CSSTokenizer fTokenizer = null;

    public CSSTextParser(int parserMode) {
        this.initializeParserMode(parserMode);
    }

    public CSSTextParser(int parserMode, Reader reader) {
        this.initializeParserMode(parserMode);
        this.reset(reader);
    }

    public CSSTextParser(int parserMode, String input) {
        this.initializeParserMode(parserMode);
        this.reset(input);
    }

    public void reset(Reader reader) {
        this.getTokenizer().reset(reader, 0);
    }

    public void reset(String input) {
        this.getTokenizer().reset(new StringReader(input), 0);
    }

    public CSSTextToken[] getTokens() {
        List tokenList = this.getTokenList();
        CSSTextToken[] tokens = new CSSTextToken[tokenList.size()];
        return tokenList.toArray(tokens);
    }

    public List getTokenList() {
        List tokens;
        try {
            tokens = this.getTokenizer().parseText();
        }
        catch (IOException iOException) {
            tokens = Collections.EMPTY_LIST;
        }
        return tokens;
    }

    private void initializeParserMode(int parserMode) {
        int bufsize;
        int initialState;
        switch (parserMode) {
            case 0: {
                initialState = 0;
                bufsize = 16384;
                break;
            }
            case 1: {
                initialState = 34;
                bufsize = 16384;
                break;
            }
            case 2: {
                initialState = 38;
                bufsize = 256;
                break;
            }
            default: {
                return;
            }
        }
        if (initialState > 0) {
            CSSTokenizer tokenizer = this.getTokenizer();
            tokenizer.setInitialState(initialState);
            tokenizer.setInitialBufferSize(bufsize);
        }
    }

    private CSSTokenizer getTokenizer() {
        if (this.fTokenizer == null) {
            this.fTokenizer = new CSSTokenizer();
        }
        return this.fTokenizer;
    }
}

