/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;

public final class TermStates {
    private static final TermState EMPTY_TERMSTATE = new TermState(){

        @Override
        public void copyFrom(TermState other) {
        }
    };
    private final Object topReaderContextIdentity;
    private final TermState[] states;
    private final Term term;
    private int docFreq;
    private long totalTermFreq;

    private TermStates(Term term, IndexReaderContext context) {
        assert (context != null && context.isTopLevel);
        this.topReaderContextIdentity = context.identity;
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        int len = context.leaves() == null ? 1 : context.leaves().size();
        this.states = new TermState[len];
        this.term = term;
    }

    public TermStates(IndexReaderContext context) {
        this(null, context);
    }

    public boolean wasBuiltFor(IndexReaderContext context) {
        return this.topReaderContextIdentity == context.identity;
    }

    public TermStates(IndexReaderContext context, TermState state, int ord, int docFreq, long totalTermFreq) {
        this(null, context);
        this.register(state, ord, docFreq, totalTermFreq);
    }

    public static TermStates build(IndexReaderContext context, Term term, boolean needsStats) throws IOException {
        assert (context != null && context.isTopLevel);
        TermStates perReaderTermState = new TermStates(needsStats ? null : term, context);
        if (needsStats) {
            for (LeafReaderContext ctx : context.leaves()) {
                TermsEnum termsEnum = TermStates.loadTermsEnum(ctx, term);
                if (termsEnum == null) continue;
                TermState termState = termsEnum.termState();
                perReaderTermState.register(termState, ctx.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
            }
        }
        return perReaderTermState;
    }

    private static TermsEnum loadTermsEnum(LeafReaderContext ctx, Term term) throws IOException {
        Terms terms = Terms.getTerms(ctx.reader(), term.field());
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum;
        }
        return null;
    }

    public void clear() {
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        Arrays.fill(this.states, null);
    }

    public void register(TermState state, int ord, int docFreq, long totalTermFreq) {
        this.register(state, ord);
        this.accumulateStatistics(docFreq, totalTermFreq);
    }

    public void register(TermState state, int ord) {
        assert (state != null) : "state must not be null";
        assert (ord >= 0 && ord < this.states.length);
        assert (this.states[ord] == null) : "state for ord: " + ord + " already registered";
        this.states[ord] = state;
    }

    public void accumulateStatistics(int docFreq, long totalTermFreq) {
        assert (docFreq >= 0);
        assert (totalTermFreq >= 0L);
        assert ((long)docFreq <= totalTermFreq);
        this.docFreq += docFreq;
        this.totalTermFreq += totalTermFreq;
    }

    public TermState get(LeafReaderContext ctx) throws IOException {
        assert (ctx.ord >= 0 && ctx.ord < this.states.length);
        if (this.term == null) {
            return this.states[ctx.ord];
        }
        if (this.states[ctx.ord] == null) {
            TermsEnum te = TermStates.loadTermsEnum(ctx, this.term);
            TermState termState = this.states[ctx.ord] = te == null ? EMPTY_TERMSTATE : te.termState();
        }
        if (this.states[ctx.ord] == EMPTY_TERMSTATE) {
            return null;
        }
        return this.states[ctx.ord];
    }

    public int docFreq() {
        if (this.term != null) {
            throw new IllegalStateException("Cannot call docFreq() when needsStats=false");
        }
        return this.docFreq;
    }

    public long totalTermFreq() {
        if (this.term != null) {
            throw new IllegalStateException("Cannot call totalTermFreq() when needsStats=false");
        }
        return this.totalTermFreq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TermStates\n");
        for (TermState termState : this.states) {
            sb.append("  state=");
            sb.append(termState);
            sb.append('\n');
        }
        return sb.toString();
    }
}

