/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.IIndexer;
import org.eclipse.dltk.core.index2.ProjectIndexer2;
import org.eclipse.dltk.internal.core.index2.AbstractIndexRequest;
import org.eclipse.dltk.internal.core.index2.IndexerManager;
import org.eclipse.dltk.internal.core.index2.ProgressJob;

public class AddSourceModuleRequest
extends AbstractIndexRequest {
    protected final ISourceModule sourceModule;

    public AddSourceModuleRequest(ProjectIndexer2 indexer, ISourceModule sourceModule, ProgressJob progressJob) {
        super(indexer, progressJob);
        this.sourceModule = sourceModule;
    }

    @Override
    protected String getName() {
        return this.sourceModule.getElementName();
    }

    @Override
    protected void run() throws CoreException, IOException {
        IIndexer indexer = IndexerManager.getIndexer();
        if (indexer == null || this.isCancelled) {
            return;
        }
        indexer.indexDocument(this.sourceModule);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sourceModule == null ? 0 : this.sourceModule.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddSourceModuleRequest other = (AddSourceModuleRequest)obj;
        return !(this.sourceModule == null ? other.sourceModule != null : !this.sourceModule.equals(other.sourceModule));
    }
}

