/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.cdt.libhover.LibhoverPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHover;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverLibrary;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.DevHelpPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.Messages;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.ParseDevHelp;

public class DevHelpGenerateJob
extends Job {
    private static final String LIBHOVER_FILE = "devhelp.libhover";
    private boolean force;

    public DevHelpGenerateJob(boolean force) {
        super(Messages.DevHelpGenerateJob_GenerateJobName);
        this.force = force;
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean outOfDate;
        List<Path> books;
        block23: {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IPreferenceStore ps = DevHelpPlugin.getDefault().getPreferenceStore();
            String devhelpDirs = ps.getString("org.eclipse.linuxtools.cdt.libhover.devhelp.directory");
            books = ParseDevHelp.findAllDevhelpBooks(devhelpDirs);
            if (books.isEmpty()) {
                monitor.done();
                return Status.OK_STATUS;
            }
            Path libhoverPath = Path.of(LibhoverPlugin.getDefault().getStateLocation().toOSString(), "C", LIBHOVER_FILE);
            outOfDate = true;
            try {
                if (!Files.exists(libhoverPath, new LinkOption[0])) break block23;
                outOfDate = false;
                FileTime ltime = Files.getLastModifiedTime(libhoverPath, new LinkOption[0]);
                for (Path book : books) {
                    FileTime ltimeBook = Files.getLastModifiedTime(book.getParent(), new LinkOption[0]);
                    if (ltime.compareTo(ltimeBook) >= 0) continue;
                    outOfDate = true;
                    break;
                }
            }
            catch (IOException e) {
                outOfDate = true;
            }
        }
        if (!outOfDate && !this.force) {
            monitor.done();
            return Status.OK_STATUS;
        }
        ParseDevHelp.DevHelpParser p = new ParseDevHelp.DevHelpParser(books);
        LibHoverInfo hover = p.parse(monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Collection libs = LibHover.getLibraries();
        for (LibHoverLibrary l : libs) {
            if (!"devhelp".equals(l.getName())) continue;
            l.setHoverinfo(hover);
            break;
        }
        try {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Path location = Path.of(LibhoverPlugin.getDefault().getStateLocation().toOSString(), "C");
            Files.createDirectories(location, new FileAttribute[0]);
            try (OutputStream f = Files.newOutputStream(location.resolve(LIBHOVER_FILE), new OpenOption[0]);
                 ObjectOutputStream out = new ObjectOutputStream(f);){
                out.writeObject(hover);
            }
            monitor.done();
        }
        catch (NullPointerException e) {
            monitor.done();
            return Status.CANCEL_STATUS;
        }
        catch (IOException e) {
            monitor.done();
            return Status.error((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

