/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.doc.internal.filters;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class HTMLHeadAndBodyInjectionStream
extends FilterOutputStream {
    private final OutputStream output;
    private final ByteBuffer currentTag;
    private final String encoding;
    private final String headContent;
    private final String bodyContent;
    private boolean scanningTag;
    private boolean done;

    public HTMLHeadAndBodyInjectionStream(OutputStream out, String encoding, String headContent, String bodyContent) {
        super(out);
        this.output = out;
        this.currentTag = ByteBuffer.allocate(1024);
        this.encoding = encoding == null ? "ASCII" : encoding;
        this.headContent = headContent;
        this.bodyContent = bodyContent;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.done) {
            super.write(b);
            return;
        }
        switch (b) {
            case 60: {
                this.currentTag.clear();
                this.scanningTag = true;
                break;
            }
            case 33: 
            case 63: {
                if (!this.scanningTag) break;
                this.emitCurrentTag();
                this.scanningTag = false;
                break;
            }
            case 62: {
                if (!this.scanningTag || !this.appendCurrentTag(b)) break;
                if (this.isHeadClose()) {
                    this.injectHead();
                    this.done = this.bodyContent == null;
                } else if (this.isBodyOpen()) {
                    this.injectBody();
                    this.done = true;
                } else {
                    this.emitCurrentTag();
                }
                this.scanningTag = false;
                return;
            }
        }
        if (this.scanningTag) {
            this.appendCurrentTag(b);
        } else {
            super.write(b);
        }
    }

    private boolean appendCurrentTag(int b) throws IOException {
        if (this.currentTag.hasRemaining()) {
            this.currentTag.put((byte)b);
            return true;
        }
        this.emitCurrentTag();
        this.scanningTag = false;
        super.write(b);
        return false;
    }

    private void emitCurrentTag() throws IOException {
        this.currentTag.flip();
        this.out.write(this.currentTag.array(), this.currentTag.position(), this.currentTag.remaining());
    }

    final boolean isHeadClose() {
        byte b;
        return !(this.currentTag.position() < 7 || (b = this.currentTag.get(0)) != 60 || (b = this.currentTag.get(1)) != 47 || (b = this.currentTag.get(2)) != 104 && b != 72 || (b = this.currentTag.get(3)) != 101 && b != 69 || (b = this.currentTag.get(4)) != 97 && b != 65 || (b = this.currentTag.get(5)) != 100 && b != 68 || (b = this.currentTag.get(6)) != 62 && b != 32 && b != 9 && b != 13 && b != 10);
    }

    final boolean isBodyOpen() {
        byte b;
        return !(this.currentTag.position() < 6 || (b = this.currentTag.get(0)) != 60 || (b = this.currentTag.get(1)) != 98 && b != 66 || (b = this.currentTag.get(2)) != 111 && b != 79 || (b = this.currentTag.get(3)) != 100 && b != 68 || (b = this.currentTag.get(4)) != 121 && b != 89 || (b = this.currentTag.get(5)) != 62 && b != 32 && b != 9 && b != 13 && b != 10);
    }

    private void injectHead() throws IOException {
        if (this.headContent != null) {
            this.emit(this.headContent);
            this.output.write(10);
        }
        this.emitCurrentTag();
    }

    private void injectBody() throws IOException {
        this.emitCurrentTag();
        if (this.bodyContent != null) {
            this.emit(this.bodyContent);
            this.output.write(10);
        }
    }

    private void emit(String content) throws IOException {
        byte[] toEmit = content.getBytes(this.encoding);
        this.output.write(toEmit);
    }
}

