/*****************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *
 *		CEA LIST - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.uml.diagram.common.locator;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.directedit.locator.CellEditorLocatorAccess;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;

/**
 * Non diagram-specific class generated by GMF Tooling.
 */
public class MultilineCellEditorLocator implements CellEditorLocator {

	/** The multiline editable figure. */
	private IMultilineEditableFigure multilineEditableFigure;

	/**
	 * Instantiates a new multiline cell editor locator.
	 *
	 * @param figure
	 *            the figure
	 */
	public MultilineCellEditorLocator(IMultilineEditableFigure figure) {
		this.multilineEditableFigure = figure;
	}

	/**
	 * Gets the multiline editable figure.
	 *
	 * @return the multiline editable figure
	 */
	public IMultilineEditableFigure getMultilineEditableFigure() {
		return multilineEditableFigure;
	}

	/**
	 * @see org.eclipse.gef.tools.CellEditorLocator#relocate(org.eclipse.jface.viewers.CellEditor)
	 *
	 * @param celleditor
	 */

	@Override
	public void relocate(CellEditor celleditor) {
		Text text = (Text) celleditor.getControl();
		Rectangle rect = getMultilineEditableFigure().getBounds().getCopy();
		rect.x = getMultilineEditableFigure().getEditionLocation().x;
		rect.y = getMultilineEditableFigure().getEditionLocation().y;
		getMultilineEditableFigure().translateToAbsolute(rect);
		if (getMultilineEditableFigure().getText().length() > 0) {
			rect.setSize(new Dimension(text.computeSize(rect.width, SWT.DEFAULT)));
		}
		if (!rect.equals(new Rectangle(text.getBounds()))) {
			text.setBounds(rect.x, rect.y, rect.width, rect.height);
		}
	}


	/**
	 * Gets the text cell editor locator.
	 *
	 * @param source
	 *            the source
	 * @return the text cell editor locator
	 * @since 5.0
	 */
	public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
		if (source.getFigure() instanceof IMultilineEditableFigure) {
			return new MultilineCellEditorLocator(
					(IMultilineEditableFigure) source.getFigure());
		} else {
			return CellEditorLocatorAccess.INSTANCE.getTextCellEditorLocator(source);

		}
	}
}
