/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.navigation.navigableElement;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.navigation.service.ExtendedNavigableElement;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class GenericNavigableElement
implements ExtendedNavigableElement {
    protected Element element;

    public GenericNavigableElement(Element element) {
        this.element = element;
    }

    public String getLabel() {
        String label = "Go to element" + this.getElementLabel() + "...";
        return label;
    }

    public String getDescription() {
        return "Go to the element " + this.getElementLabel();
    }

    protected String getElementLabel() {
        if (this.element == null) {
            return " (Undefined)";
        }
        if (this.element instanceof NamedElement) {
            if (((NamedElement)this.element).getName() == null || ((NamedElement)this.element).getName().isEmpty()) {
                return " (Unnamed)";
            }
            return " (" + UMLLabelInternationalization.getInstance().getLabel((NamedElement)this.element) + ")";
        }
        return " (Unnamed)";
    }

    @Deprecated
    public void navigate(IRevealSemanticElement navigationContext) {
        if (!this.isEnabled()) {
            return;
        }
        navigationContext.revealSemanticElement(Collections.singletonList(this.element));
    }

    public Image getImage() {
        if (this.element == null) {
            return null;
        }
        try {
            return ((LabelProviderService)ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)this.element).getService(LabelProviderService.class)).getLabelProvider().getImage((Object)this.element);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isEnabled() {
        return this.element != null;
    }

    public boolean navigate(NavigationTarget navigationContext) {
        if (!this.isEnabled()) {
            return false;
        }
        return navigationContext.revealElement((Object)this.element);
    }

    public Element getElement() {
        return this.element;
    }

    public Object getSemanticElement() {
        return this.getElement();
    }
}

