/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.persistence.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.persistence.internal.PersistenceDelegateBinding;
import org.osgi.framework.Bundle;

public class PersistenceDelegateBindingExtensionPointManager
extends AbstractExtensionPointManager<PersistenceDelegateBinding> {
    PersistenceDelegateBindingExtensionPointManager() {
    }

    public static PersistenceDelegateBindingExtensionPointManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.runtime.persistence.bindings";
    }

    protected String getConfigurationElementName() {
        return "binding";
    }

    protected ExecutableExtensionProxy<PersistenceDelegateBinding> doCreateExtensionProxy(IConfigurationElement element) throws CoreException {
        return new ExecutableExtensionProxy<PersistenceDelegateBinding>(element){

            public PersistenceDelegateBinding newInstance() {
                PersistenceDelegateBinding instance = new PersistenceDelegateBinding();
                try {
                    instance.setInitializationData(this.getConfigurationElement(), null, null);
                }
                catch (CoreException e) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
                return instance;
            }
        };
    }

    public PersistenceDelegateBinding[] getApplicableBindings(Object context, Object container) {
        ArrayList<PersistenceDelegateBinding> applicable = new ArrayList<PersistenceDelegateBinding>();
        PersistenceDelegateBinding[] persistenceDelegateBindingArray = this.getBindings();
        int n = persistenceDelegateBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isApplicable;
            PersistenceDelegateBinding binding = persistenceDelegateBindingArray[n2];
            Expression enablement = binding.getEnablement();
            boolean bl = isApplicable = enablement == null;
            if (enablement != null) {
                if (context != null) {
                    EvaluationContext evalContext = new EvaluationContext(null, context);
                    evalContext.addVariable("context", context);
                    if (context instanceof Class) {
                        evalContext.addVariable("contextClass", (Object)((Class)context).getName());
                    } else {
                        evalContext.addVariable("contextClass", (Object)context.getClass().getName());
                    }
                    if (container != null) {
                        evalContext.addVariable("container", container);
                        if (container instanceof Class) {
                            evalContext.addVariable("containerClass", (Object)((Class)container).getName());
                        } else {
                            evalContext.addVariable("containerClass", (Object)container.getClass().getName());
                        }
                    }
                    evalContext.setAllowPluginActivation(true);
                    try {
                        isApplicable = enablement.evaluate((IEvaluationContext)evalContext).equals(EvaluationResult.TRUE);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                    }
                } else {
                    isApplicable = false;
                }
            }
            if (isApplicable) {
                applicable.add(binding);
            }
            ++n2;
        }
        Collections.sort(applicable, new SortByPriority());
        if (applicable.size() > 1) {
            ArrayList<PersistenceDelegateBinding> overwritten = new ArrayList<PersistenceDelegateBinding>();
            for (PersistenceDelegateBinding candidate : applicable) {
                for (PersistenceDelegateBinding overwriter : applicable) {
                    String[] overwrites = overwriter.getOverwrites();
                    if (overwrites == null || !Arrays.asList(overwrites).contains(candidate.getId())) continue;
                    overwritten.add(candidate);
                }
            }
            for (PersistenceDelegateBinding toRemove : overwritten) {
                applicable.remove((Object)toRemove);
            }
        }
        return applicable.toArray(new PersistenceDelegateBinding[applicable.size()]);
    }

    public PersistenceDelegateBinding[] getBindings() {
        ArrayList<PersistenceDelegateBinding> contributions = new ArrayList<PersistenceDelegateBinding>();
        Collection persistenceDelegateBindings = this.getExtensions().values();
        for (ExecutableExtensionProxy persistenceDelegateBinding : persistenceDelegateBindings) {
            PersistenceDelegateBinding instance = (PersistenceDelegateBinding)((Object)persistenceDelegateBinding.getInstance());
            if (instance == null || contributions.contains((Object)instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new PersistenceDelegateBinding[contributions.size()]);
    }

    public PersistenceDelegateBinding getBinding(String id) {
        PersistenceDelegateBinding contribution = null;
        if (this.getExtensions().containsKey(id)) {
            ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
            contribution = (PersistenceDelegateBinding)((Object)proxy.getInstance());
        }
        return contribution;
    }

    private static class LazyInstance {
        public static PersistenceDelegateBindingExtensionPointManager instance = new PersistenceDelegateBindingExtensionPointManager();

        private LazyInstance() {
        }
    }

    static class SortByPriority
    implements Comparator<PersistenceDelegateBinding> {
        SortByPriority() {
        }

        @Override
        public int compare(PersistenceDelegateBinding o1, PersistenceDelegateBinding o2) {
            if (o1 != null && o2 != null) {
                String p2;
                String p1 = o1.getPriority();
                if (p1 == null || "".equals(p1)) {
                    p1 = "normal";
                }
                if ((p2 = o2.getPriority()) == null || "".equals(p1)) {
                    p2 = "normal";
                }
                int i1 = 0;
                if ("lowest".equalsIgnoreCase(p1)) {
                    i1 = -3;
                }
                if ("lower".equalsIgnoreCase(p1)) {
                    i1 = -2;
                }
                if ("low".equalsIgnoreCase(p1)) {
                    i1 = -1;
                }
                if ("high".equalsIgnoreCase(p1)) {
                    i1 = 1;
                }
                if ("higher".equalsIgnoreCase(p1)) {
                    i1 = 2;
                }
                if ("highest".equalsIgnoreCase(p1)) {
                    i1 = 3;
                }
                int i2 = 0;
                if ("lowest".equalsIgnoreCase(p2)) {
                    i2 = -3;
                }
                if ("lower".equalsIgnoreCase(p2)) {
                    i2 = -2;
                }
                if ("low".equalsIgnoreCase(p2)) {
                    i2 = -1;
                }
                if ("high".equalsIgnoreCase(p2)) {
                    i2 = 1;
                }
                if ("higher".equalsIgnoreCase(p2)) {
                    i2 = 2;
                }
                if ("highest".equalsIgnoreCase(p2)) {
                    i2 = 3;
                }
                if (i1 < i2) {
                    return 1;
                }
                if (i1 > i2) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

