/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.viatra.query.runtime.ui.ViatraQueryRuntimeUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;

public class QueryRegistryTreeLabelProvider
extends ColumnLabelProvider {
    private final ImageRegistry imageRegistry = ViatraQueryRuntimeUIPlugin.getDefault().getImageRegistry();

    public Image getImage(Object element) {
        return this.getImageInternal(element);
    }

    protected Image _getImageInternal(QueryRegistryTreeEntry element) {
        return this.imageRegistry.get("vql");
    }

    protected Image _getImageInternal(QueryRegistryTreeSource element) {
        IResource member;
        String sourceId = element.getSourceIdentifier();
        boolean _startsWith = sourceId.startsWith("dynamic:");
        if (_startsWith && (member = ResourcesPlugin.getWorkspace().getRoot().findMember(sourceId.replace("dynamic:", ""))) instanceof IProject) {
            return this.imageRegistry.get("project");
        }
        return this.imageRegistry.get("navigator_root");
    }

    protected Image _getImageInternal(QueryRegistryTreePackage element) {
        return this.imageRegistry.get("epackage");
    }

    protected Image _getImageInternal(Object element) {
        return super.getImage(element);
    }

    public String getText(Object element) {
        return this.getTextInternal(element);
    }

    protected String _getTextInternal(QueryRegistryTreeEntry element) {
        return element.getSimpleName();
    }

    protected String _getTextInternal(QueryRegistryTreeSource element) {
        String sourceId = element.getSourceIdentifier();
        boolean _equals = Objects.equals(sourceId, "org.eclipse.viatra.query.runtime.querygroup.extension.based.connector");
        if (_equals) {
            return "Registered queries";
        }
        boolean _startsWith = sourceId.startsWith("dynamic:");
        if (_startsWith) {
            String label = sourceId.replace("dynamic:", "");
            return label;
        }
        return sourceId;
    }

    protected String _getTextInternal(QueryRegistryTreePackage element) {
        return element.getPackageName();
    }

    protected String _getTextInternal(Object element) {
        return super.getText(element);
    }

    public Image getImageInternal(Object element) {
        if (element instanceof QueryRegistryTreeEntry) {
            return this._getImageInternal((QueryRegistryTreeEntry)element);
        }
        if (element instanceof QueryRegistryTreePackage) {
            return this._getImageInternal((QueryRegistryTreePackage)element);
        }
        if (element instanceof QueryRegistryTreeSource) {
            return this._getImageInternal((QueryRegistryTreeSource)element);
        }
        if (element != null) {
            return this._getImageInternal(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    public String getTextInternal(Object element) {
        if (element instanceof QueryRegistryTreeEntry) {
            return this._getTextInternal((QueryRegistryTreeEntry)element);
        }
        if (element instanceof QueryRegistryTreePackage) {
            return this._getTextInternal((QueryRegistryTreePackage)element);
        }
        if (element instanceof QueryRegistryTreeSource) {
            return this._getTextInternal((QueryRegistryTreeSource)element);
        }
        if (element != null) {
            return this._getTextInternal(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }
}

