/*******************************************************************************
 * Copyright (c) 2003, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.componentcore.internal.util;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;

public class SourcePathProvider implements IPathProvider {
	
	public static IPathProvider INSTANCE = new SourcePathProvider();
	
	private SourcePathProvider() {} 

	/* (non-Javadoc)
	 * @see org.eclipse.wst.common.modulecore.util.IPathProvider#getPath(org.eclipse.wst.common.modulecore.WorkbenchComponent)
	 */
	public IPath getPath(ComponentResource aModuleResource) {
		return aModuleResource.getSourcePath();
	}

	public EStructuralFeature getFeature() {
		return ComponentcorePackage.eINSTANCE.getComponentResource_SourcePath();
	}
	
}
