/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.connect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.connect.AttachingConnector;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.BrowserArgument;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.ConsoleArgument;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.DOMArgument;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.HostArgument;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.InspectorArgument;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.Messages;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.NetArgument;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.PortArgument;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.TimeoutArgument;
import org.eclipse.wst.jsdt.debug.internal.crossfire.connect.TraceArgument;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFVirtualMachine;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFTransportService;
import org.eclipse.wst.jsdt.debug.transport.Connection;
import org.eclipse.wst.jsdt.debug.transport.DebugSession;

public class CrossfireAttachingConnector
implements AttachingConnector {
    public static final String CROSSFIRE_REMOTE_ATTACH_CONNECTOR_ID = "crossfire.remote.attach.connector";

    public Map defaultArguments() {
        HashMap<String, Object> args = new HashMap<String, Object>(5);
        args.put("host", new HostArgument(null));
        args.put("port", new PortArgument(5000));
        args.put("timeout", new TimeoutArgument());
        args.put("console", new ConsoleArgument());
        args.put("dom", new DOMArgument());
        args.put("inspector", new InspectorArgument());
        args.put("net", new NetArgument());
        args.put("trace", new TraceArgument());
        if (!"win32".equals(Platform.getOS())) {
            args.put("browser", new BrowserArgument());
        }
        return args;
    }

    public String description() {
        return Messages.attach_connector_desc;
    }

    public String name() {
        return Messages.crossfire_remote_attach;
    }

    public String id() {
        return CROSSFIRE_REMOTE_ATTACH_CONNECTOR_ID;
    }

    public VirtualMachine attach(Map arguments) throws IOException {
        boolean browser;
        String str = (String)arguments.get("browser");
        boolean bl = browser = Boolean.valueOf(str) != false && !"win32".equals(Platform.getOS());
        if (browser && !HostArgument.isLocalhost((String)arguments.get("host"))) {
            throw new IOException(Messages.cannot_launch_browser_not_localhost);
        }
        Connection c = null;
        c = browser ? this.launchForBrowser(arguments) : this.launch(arguments);
        DebugSession session = new DebugSession(c);
        return new CFVirtualMachine(session);
    }

    Connection launchForBrowser(Map arguments) throws IOException {
        String host = (String)arguments.get("host");
        String port = (String)arguments.get("port");
        StringBuffer buffer = new StringBuffer("firefox -ProfileManager -load-fb-modules -crossfire-server-port ").append(port);
        Process p = Runtime.getRuntime().exec(buffer.toString());
        CFTransportService service = new CFTransportService(this.getToolArgs(arguments));
        String timeoutstr = (String)arguments.get("timeout");
        int timeout = Integer.parseInt(timeoutstr);
        buffer = new StringBuffer();
        buffer.append(host).append(':').append(Integer.parseInt(port));
        long timer = System.currentTimeMillis() + 20000L;
        Connection c = null;
        while (p != null && System.currentTimeMillis() < timer && c == null) {
            try {
                c = service.attach(buffer.toString(), timeout, timeout);
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (c == null) {
            throw new IOException(NLS.bind((String)Messages.failed_to_attach_to_auto_browser, (Object[])new String[]{host, port}));
        }
        return c;
    }

    Connection launch(Map arguments) throws IOException {
        CFTransportService service = new CFTransportService(this.getToolArgs(arguments));
        String host = (String)arguments.get("host");
        String port = (String)arguments.get("port");
        String timeoutstr = (String)arguments.get("timeout");
        int timeout = Integer.parseInt(timeoutstr);
        StringBuffer buffer = new StringBuffer();
        buffer.append(host).append(':').append(Integer.parseInt(port));
        return service.attach(buffer.toString(), timeout, timeout);
    }

    String[] getToolArgs(Map arguments) {
        ArrayList<String> tools = new ArrayList<String>();
        String value = (String)arguments.get("console");
        if (Boolean.valueOf(value).booleanValue()) {
            tools.add("console");
        }
        if (Boolean.valueOf(value = (String)arguments.get("dom")).booleanValue()) {
            tools.add("dom");
        }
        if (Boolean.valueOf(value = (String)arguments.get("inspector")).booleanValue()) {
            tools.add("inspector");
        }
        if (Boolean.valueOf(value = (String)arguments.get("net")).booleanValue()) {
            tools.add("net");
        }
        if (Boolean.valueOf(value = (String)arguments.get("trace")).booleanValue()) {
            tools.add("trace");
        }
        return tools.toArray(new String[tools.size()]);
    }
}

