/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.burningwave.core.Criteria;
import org.burningwave.core.classes.CriteriaWithClassElementsSupplyingSupport;
import org.burningwave.core.function.TriPredicate;

public abstract class MemberCriteria<M extends Member, C extends MemberCriteria<M, C, T>, T extends Criteria.TestContext<M, C>>
extends CriteriaWithClassElementsSupplyingSupport<M, C, T> {
    private static Member[] EMPTY_MEMBERS_ARRAY = new Member[0];
    TriPredicate<C, Class<?>, Class<?>> scanUpToPredicate;
    TriPredicate<C, Class<?>, Class<?>> skipClassPredicate;
    Predicate<Collection<M>> resultPredicate;

    BiPredicate<Class<?>, Class<?>> getScanUpToPredicate() {
        return this.scanUpToPredicate != null ? (initialClassFrom, currentClass) -> this.scanUpToPredicate.test((C)this, (Class<?>)initialClassFrom, (Class<?>)currentClass) : (initialClassFrom, currentClass) -> currentClass.getName().equals(Object.class.getName());
    }

    C scanUpTo(Predicate<Class<?>> predicate) {
        this.scanUpToPredicate = (criteria, initialClassFrom, currentClass) -> predicate.test((Class<?>)currentClass);
        return (C)this;
    }

    C scanUpTo(BiPredicate<Class<?>, Class<?>> predicate) {
        this.scanUpToPredicate = (criteria, initialClassFrom, currentClass) -> predicate.test((Class<?>)initialClassFrom, (Class<?>)currentClass);
        return (C)this;
    }

    C scanUpTo(TriPredicate<Map<Class<?>, Class<?>>, Class<?>, Class<?>> predicate) {
        this.scanUpToPredicate = (criteria, initialClassFrom, currentClass) -> predicate.test(criteria.getUploadedClasses(), (Class<?>)initialClassFrom, (Class<?>)currentClass);
        return (C)this;
    }

    public C skip(TriPredicate<Map<Class<?>, Class<?>>, Class<?>, Class<?>> predicate) {
        this.skipClassPredicate = this.skipClassPredicate != null ? this.skipClassPredicate.or((criteria, initialClassFrom, currentClass) -> predicate.test(criteria.getUploadedClasses(), (Class<?>)initialClassFrom, (Class<?>)currentClass)) : (criteria, initialClassFrom, currentClass) -> predicate.test(criteria.getUploadedClasses(), (Class<?>)initialClassFrom, (Class<?>)currentClass);
        return (C)this;
    }

    public C skip(BiPredicate<Class<?>, Class<?>> predicate) {
        this.skipClassPredicate = this.skipClassPredicate != null ? this.skipClassPredicate.or((criteria, initialClassFrom, currentClass) -> predicate.test((Class<?>)initialClassFrom, (Class<?>)currentClass)) : (criteria, initialClassFrom, currentClass) -> predicate.test((Class<?>)initialClassFrom, (Class<?>)currentClass);
        return (C)this;
    }

    public C result(Predicate<Collection<M>> resultPredicate) {
        this.resultPredicate = resultPredicate;
        return (C)this;
    }

    Predicate<Collection<M>> getResultPredicate() {
        return this.resultPredicate;
    }

    @Override
    protected C logicOperation(C leftCriteria, C rightCriteria, Function<BiPredicate<T, M>, Function<BiPredicate<? super T, ? super M>, BiPredicate<T, M>>> binaryOperator, C targetCriteria) {
        MemberCriteria newCriteria = (MemberCriteria)super.logicOperation(leftCriteria, rightCriteria, binaryOperator, targetCriteria);
        TriPredicate<C, Class<?>, Class<?>> triPredicate = ((MemberCriteria)leftCriteria).scanUpToPredicate != null ? (((MemberCriteria)rightCriteria).scanUpToPredicate != null ? ((MemberCriteria)leftCriteria).scanUpToPredicate.or(((MemberCriteria)rightCriteria).scanUpToPredicate) : null) : (newCriteria.scanUpToPredicate = null);
        newCriteria.skipClassPredicate = ((MemberCriteria)leftCriteria).skipClassPredicate != null ? (((MemberCriteria)rightCriteria).skipClassPredicate != null ? ((MemberCriteria)leftCriteria).skipClassPredicate.or(((MemberCriteria)rightCriteria).skipClassPredicate) : ((MemberCriteria)leftCriteria).skipClassPredicate) : ((MemberCriteria)rightCriteria).skipClassPredicate;
        return (C)newCriteria;
    }

    public C name(Predicate<String> predicate) {
        this.predicate = this.concat(this.predicate, (context, member) -> predicate.test(member.getName()));
        return (C)this;
    }

    @Override
    public C createCopy() {
        MemberCriteria copy = (MemberCriteria)super.createCopy();
        copy.scanUpToPredicate = this.scanUpToPredicate;
        copy.skipClassPredicate = this.skipClassPredicate;
        copy.resultPredicate = this.resultPredicate;
        return (C)copy;
    }

    abstract Function<Class<?>, M[]> getMembersSupplierFunction();

    BiFunction<Class<?>, Class<?>, M[]> getMembersSupplier() {
        return (initialClassFrom, currentClass) -> this.skipClassPredicate == null || !this.skipClassPredicate.test((C)this, (Class<?>)initialClassFrom, (Class<?>)currentClass) ? (Member[])this.getMembersSupplierFunction().apply((Class<?>)currentClass) : EMPTY_MEMBERS_ARRAY;
    }
}

