/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MIDataReadMemory
extends MICommand<MIDataReadMemoryInfo> {
    int fword_size;

    public MIDataReadMemory(IDMContext ctx, long offset, String address, int word_format, int word_size, int rows, int cols, Character asChar) {
        super(ctx, "-data-read-memory");
        this.fword_size = word_size;
        if (offset != 0L) {
            this.setOptions(new String[]{"-o", Long.toString(offset)});
        }
        String format = "x";
        switch (word_format) {
            case 15: {
                format = "u";
                break;
            }
            case 10: {
                format = "f";
                break;
            }
            case 11: {
                format = "a";
                break;
            }
            case 12: {
                format = "i";
                break;
            }
            case 13: {
                format = "c";
                break;
            }
            case 14: {
                format = "s";
                break;
            }
            case 3: 
            case 5: {
                format = "d";
                break;
            }
            case 2: {
                format = "t";
                break;
            }
            case 1: {
                format = "o";
                break;
            }
            default: {
                format = "x";
            }
        }
        if (asChar == null) {
            this.setParameters(new String[]{address, format, Integer.toString(word_size), Integer.toString(rows), Integer.toString(cols)});
        } else {
            this.setParameters(new String[]{address, format, Integer.toString(word_size), Integer.toString(rows), Integer.toString(cols), asChar.toString()});
        }
    }

    @Override
    public MIDataReadMemoryInfo getResult(MIOutput out) {
        return new MIDataReadMemoryInfo(out, this.fword_size);
    }
}

