/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.vnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IDependencyNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.ISchemaNode;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.AbstractOnDemandContentProviderNav;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ServerExplorerVNodeContentProviderNav
extends AbstractOnDemandContentProviderNav {
    private static DatabaseDefinitionRegistry registry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
    private static final String TABLE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.TABLE");
    private static final String ROUTINE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.ROUTINE");
    private static final String SEQUENCE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.SEQUENCE");
    private static final String UDT = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.UDT");
    private static final String VIEW = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.VIEW");
    private static final String TRIGGER = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.TRIGGER");
    private static final String INDEX = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.INDEX");
    private static final String CONSTRAINT = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.CONSTRAINT");
    private static final String COLUMN = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.COLUMN");
    private static final String DATABASE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.DATABASE");
    private static final String SCHEMA = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.SCHEMA");
    private static final String DEPENDENCY = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.DEPENDENCY");
    private static final String STORED_PROCEDURE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.STORED_PROCEDURE");
    private static final String UDF = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.UDF");
    private static final String CATALOG = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.CATALOG");
    private static final String AUTHORIZATION_ID = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.AUTH_ID");
    private static final String ROLE = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.ROLE");
    private static final String USER = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.USER");
    private static final String GROUP = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.GROUP");

    private DatabaseDefinition getDatabaseDefinition(Object parent) {
        if (parent instanceof Database) {
            return registry.getDefinition((Database)parent);
        }
        if (parent instanceof ICatalogObject) {
            return registry.getDefinition(((ICatalogObject)parent).getCatalogDatabase());
        }
        if (parent instanceof Schema) {
            Schema schema = (Schema)parent;
            Catalog catalog = schema.getCatalog();
            Database database = catalog == null ? schema.getDatabase() : catalog.getDatabase();
            return registry.getDefinition(database);
        }
        if (parent instanceof Table) {
            return this.getDatabaseDefinition(((Table)parent).getSchema());
        }
        return null;
    }

    private Collection getChildren(String groupID, List children) {
        ArrayList<EObject> list = new ArrayList<EObject>(children.size());
        for (EObject child : children) {
            if (!groupID.equals(containmentService.getGroupId(child))) continue;
            list.add(child);
        }
        return list;
    }

    @Override
    protected Object[] displayCatalogNodeChildren(Object parent) {
        Database database = (Database)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)database.getCatalogs()));
    }

    @Override
    protected Object[] displayCatalogChildren(Object parent) {
        ArrayList<ISchemaNode> collection = new ArrayList<ISchemaNode>(1);
        collection.add(nodeFactory.makeSchemaNode(SCHEMA, SCHEMA, parent));
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displaySchemaNodeChildren(Object parent) {
        Object modelParent = ((IVirtualNode)parent).getParent();
        if (modelParent instanceof Catalog) {
            return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)((Catalog)modelParent).getSchemas()));
        }
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)((Database)modelParent).getSchemas()));
    }

    @Override
    protected Object[] displaySchemaChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(7);
        collection.add(nodeFactory.makeTableNode(TABLE, TABLE, parent));
        collection.add(nodeFactory.makeViewNode(VIEW, VIEW, parent));
        if (df.supportsStoredProcedures()) {
            collection.add(nodeFactory.makeStoredProcedureNode(STORED_PROCEDURE, STORED_PROCEDURE, parent));
        }
        collection.add(nodeFactory.makeUDFNode(UDF, UDF, parent));
        if (df.supportsSequence()) {
            collection.add(nodeFactory.makeSequenceNode(SEQUENCE, SEQUENCE, parent));
        }
        if (df.supportsUserDefinedType()) {
            collection.add(nodeFactory.makeUDTNode(UDT, UDT, parent));
        }
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displayServerChildren(Object parent) {
        return EMPTY_ELEMENT_ARRAY;
    }

    protected Object[] displayDatabaseNodeChildren(Object parent) {
        return EMPTY_ELEMENT_ARRAY;
    }

    @Override
    protected Object[] displayTableNodeChildren(Object parent) {
        EReference feature = SQLSchemaPackage.eINSTANCE.getSchema_Tables();
        return this.getSchemaChildren(parent, (EStructuralFeature)feature);
    }

    @Override
    protected Object[] displayUDFNodeChildren(Object parent) {
        EReference feature = SQLSchemaPackage.eINSTANCE.getSchema_Routines();
        return this.getSchemaChildren(parent, (EStructuralFeature)feature);
    }

    @Override
    protected Object[] displayStoredProcedureNodeChildren(Object parent) {
        EReference feature = SQLSchemaPackage.eINSTANCE.getSchema_Routines();
        return this.getSchemaChildren(parent, (EStructuralFeature)feature);
    }

    @Override
    protected Object[] displaySequenceNodeChildren(Object parent) {
        EReference feature = SQLSchemaPackage.eINSTANCE.getSchema_Sequences();
        return this.getSchemaChildren(parent, (EStructuralFeature)feature);
    }

    @Override
    protected Object[] displayUDTNodeChildren(Object parent) {
        EReference feature = SQLSchemaPackage.eINSTANCE.getSchema_UserDefinedTypes();
        return this.getSchemaChildren(parent, (EStructuralFeature)feature);
    }

    @Override
    protected Object[] displayViewsNodeChildren(Object parent) {
        EReference feature = SQLSchemaPackage.eINSTANCE.getSchema_Tables();
        return this.getSchemaChildren(parent, (EStructuralFeature)feature);
    }

    protected Object[] getSchemaChildren(Object parent, EStructuralFeature feature) {
        Object ancestor = ((IVirtualNode)parent).getParent();
        if (ancestor instanceof Schema) {
            Schema schema = (Schema)ancestor;
            return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)schema.eGet(feature)));
        }
        if (ancestor instanceof Database) {
            EList schemas = ((Database)ancestor).getSchemas();
            return this.getSchemasChildren(parent, (List)schemas, feature);
        }
        if (ancestor instanceof Catalog) {
            EList schemas = ((Catalog)ancestor).getSchemas();
            return this.getSchemasChildren(parent, (List)schemas, feature);
        }
        return EMPTY_ELEMENT_ARRAY;
    }

    private Object[] getSchemasChildren(Object parent, List schemas, EStructuralFeature feature) {
        ArrayList result = new ArrayList();
        for (Schema schema : schemas) {
            List objs = (List)schema.eGet(feature);
            result.addAll(objs);
        }
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), result));
    }

    @Override
    protected Object[] displayTriggerNodeChildren(Object parent) {
        Table table = (Table)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getTriggers()));
    }

    @Override
    protected Object[] displayIndexNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getIndex()));
    }

    @Override
    protected Object[] displayConstraintNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getConstraints()));
    }

    @Override
    protected Object[] displayColumnNodeChildren(Object parent) {
        Table table = (Table)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)table.getColumns()));
    }

    @Override
    protected Object[] displayTableChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(5);
        collection.add(nodeFactory.makeColumnNode(COLUMN, COLUMN, parent));
        if (df.supportsTriggers()) {
            collection.add(nodeFactory.makeTriggerNode(TRIGGER, TRIGGER, parent));
        }
        collection.add(nodeFactory.makeIndexNode(INDEX, INDEX, parent));
        collection.add(nodeFactory.makeConstraintNode(CONSTRAINT, CONSTRAINT, parent));
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displayViewChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(3);
        collection.add(nodeFactory.makeColumnNode(COLUMN, COLUMN, parent));
        if (df.supportsViewTriggers()) {
            collection.add(nodeFactory.makeTriggerNode(TRIGGER, TRIGGER, parent));
        }
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displayDatabaseChildren(Object parent) {
        DatabaseDefinition df = this.getDatabaseDefinition(parent);
        ArrayList<Object> collection = new ArrayList<Object>(2);
        EList catalogs = ((Database)parent).getCatalogs();
        if (catalogs.size() == 0) {
            collection.add(nodeFactory.makeSchemaNode(SCHEMA, SCHEMA, parent));
        } else {
            for (Catalog catalog : catalogs) {
                if (catalog.getName().length() != 0) continue;
                collection.add(nodeFactory.makeSchemaNode(SCHEMA, SCHEMA, (Object)catalog));
                break;
            }
        }
        if (collection.size() == 0 || catalogs.size() > 1) {
            collection.add(nodeFactory.makeCatalogNode(CATALOG, CATALOG, parent));
        }
        if (df.isAuthorizationIdentifierSupported()) {
            boolean isAuthorizationSupported;
            boolean bl = isAuthorizationSupported = !df.isUserSupported() && !df.isGroupSupported() && !df.isRoleSupported();
            if (isAuthorizationSupported) {
                collection.add(nodeFactory.makeAuthorizationIdNode(AUTHORIZATION_ID, AUTHORIZATION_ID, parent));
            }
            if (df.isUserSupported()) {
                collection.add(nodeFactory.makeUserNode(USER, USER, parent));
            }
            if (df.isRoleSupported()) {
                collection.add(nodeFactory.makeRoleNode(ROLE, ROLE, parent));
            }
            if (df.isGroupSupported()) {
                collection.add(nodeFactory.makeGroupNode(GROUP, GROUP, parent));
            }
        }
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displayDependencyNodeChildren(Object parent) {
        SQLObject object = (SQLObject)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)object.getDependencies()));
    }

    @Override
    protected Object[] displayGroupNodeChildren(Object parent) {
        Database object = (Database)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)object.getAuthorizationIds()));
    }

    @Override
    protected Object[] displayRoleNodeChildren(Object parent) {
        Database object = (Database)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)object.getAuthorizationIds()));
    }

    @Override
    protected Object[] displayUserNodeChildren(Object parent) {
        Database object = (Database)((IVirtualNode)parent).getParent();
        return this.getArrays(parent, this.getChildren(((IVirtualNode)parent).getGroupID(), (List)object.getAuthorizationIds()));
    }

    @Override
    protected Object[] displayStoredProcedureChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displayTriggerChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displayUDFChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displayColumnChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displayIndexChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }

    @Override
    protected Object[] displayConstraintChildren(Object parent) {
        ArrayList<IDependencyNode> collection = new ArrayList<IDependencyNode>(1);
        collection.add(nodeFactory.makeDependencyNode(DEPENDENCY, DEPENDENCY, parent));
        return this.getArrays(parent, collection);
    }
}

