/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.filesystem.features;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.examples.mm.filesystem.File;
import org.eclipse.graphiti.examples.mm.filesystem.Folder;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DeleteInnerFileFeature
extends AbstractCustomFeature {
    public DeleteInnerFileFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Delete File";
    }

    public String getDescription() {
        return "Deletes the selected file inside this folder";
    }

    public boolean isAvailable(IContext context) {
        return this.getFileDomainObject(context) != null;
    }

    public boolean canExecute(ICustomContext context) {
        return this.getFileDomainObject((IContext)context) != null;
    }

    public void execute(ICustomContext context) {
        File file = this.getFileDomainObject((IContext)context);
        EcoreUtil.delete((EObject)file);
    }

    private File getFileDomainObject(IContext context) {
        PictogramElement pictogramElement;
        Object domainObject;
        PictogramElement[] pictogramElements;
        if (context instanceof ICustomContext && (pictogramElements = ((ICustomContext)context).getPictogramElements()).length == 1 && (domainObject = this.getBusinessObjectForPictogramElement(pictogramElement = pictogramElements[0])) instanceof File && pictogramElement instanceof Shape && pictogramElement.eContainer() instanceof ContainerShape && pictogramElement.eContainer().eContainer() instanceof ContainerShape && this.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)pictogramElement.eContainer().eContainer())) instanceof Folder) {
            return (File)domainObject;
        }
        return null;
    }
}

