/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.target;

import java.util.regex.Pattern;

public class LaunchTargetUtils {
    private static final Pattern INVALID_NAME_PATTERN = Pattern.compile("[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]");

    private LaunchTargetUtils() {
    }

    public static boolean isInvalidName(String name) {
        return INVALID_NAME_PATTERN.matcher(name).find();
    }

    public static String sanitizeName(String name) {
        return INVALID_NAME_PATTERN.matcher(name).replaceAll("_");
    }
}

