/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.launchcontext;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.launch.core.bindings.LaunchConfigTypeBindingsManager;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.selection.RemoteSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.launch.ui.interfaces.ILaunchConfigurationTabFormPart;
import org.eclipse.tcf.te.launch.ui.tabs.launchcontext.AbstractContextSelectorTab;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.ui.controls.ContextSelectorSectionControl;
import org.eclipse.tcf.te.ui.views.controls.AbstractContextSelectorControl;
import org.eclipse.tcf.te.ui.views.sections.AbstractContextSelectorSection;
import org.eclipse.ui.forms.IManagedForm;

public abstract class AbstractLaunchContextMainTab
extends AbstractContextSelectorTab {
    ILaunchConfiguration configuration = null;

    public void initializeFrom(ILaunchConfiguration configuration) {
        AbstractContextSelectorControl control;
        super.initializeFrom(configuration);
        this.configuration = configuration;
        if (this.getContextSelectorSection() != null && (control = (AbstractContextSelectorControl)this.getContextSelectorSection().getAdapter(AbstractContextSelectorControl.class)) != null && control.getViewer() != null) {
            control.getViewer().refresh();
        }
    }

    protected MainTabContextSelectorSection doCreateContextSelectorSection(IManagedForm form, Composite panel) {
        return new MainTabContextSelectorSection(form, panel);
    }

    protected class MainTabContextSelectorControl
    extends ContextSelectorSectionControl {
        public MainTabContextSelectorControl(MainTabContextSelectorSection section, IDialogPage parentPage) {
            super((AbstractContextSelectorSection)section, parentPage);
        }

        protected ViewerFilter[] doCreateViewerFilters() {
            ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>(Arrays.asList(super.doCreateViewerFilters()));
            filters.add(new MainTabContextSelectorViewerFilter());
            return filters.toArray(new ViewerFilter[filters.size()]);
        }
    }

    protected class MainTabContextSelectorSection
    extends org.eclipse.tcf.te.tcf.ui.sections.AbstractContextSelectorSection
    implements ILaunchConfigurationTabFormPart {
        public MainTabContextSelectorSection(IManagedForm form, Composite parent) {
            super(form, parent);
        }

        protected AbstractContextSelectorControl doCreateContextSelector() {
            MainTabContextSelectorControl control = new MainTabContextSelectorControl(this, null);
            return control;
        }

        protected String getContextListDataKey() {
            return "org.eclipse.tcf.te.launch.launch_contexts";
        }

        public void initializeFrom(ILaunchConfiguration configuration) {
            IModelNode[] contexts;
            Assert.isNotNull((Object)configuration);
            if (this.selector != null && (contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)configuration)) != null && contexts.length > 0) {
                ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
                IModelNode[] iModelNodeArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelNode node = iModelNodeArray[n2];
                    if (node != null && !nodes.contains(node)) {
                        nodes.add(node);
                    }
                    ++n2;
                }
                if (!nodes.isEmpty()) {
                    this.selector.setCheckedModelContexts(nodes.toArray(new IModelNode[nodes.size()]));
                }
            }
        }

        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            Assert.isNotNull((Object)configuration);
            if (this.selector != null) {
                IModelNode[] nodes = this.selector.getCheckedModelContexts();
                if (nodes != null && nodes.length > 0) {
                    LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchConfigurationWorkingCopy)configuration, (IModelNode[])nodes);
                } else {
                    LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchConfigurationWorkingCopy)configuration, null);
                }
            } else {
                LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchConfigurationWorkingCopy)configuration, null);
            }
        }

        public boolean isValid(ILaunchConfiguration configuration) {
            return this.isValid();
        }

        public void dataChanged() {
            this.getManagedForm().dirtyStateChanged();
        }

        protected void doConfigureContextSelector(AbstractContextSelectorControl contextSelector) {
        }
    }

    protected class MainTabContextSelectorViewerFilter
    extends ViewerFilter {
        protected MainTabContextSelectorViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IPeerNode) {
                String typeId = null;
                if (AbstractLaunchContextMainTab.this.configuration != null) {
                    try {
                        typeId = AbstractLaunchContextMainTab.this.configuration.getType().getIdentifier();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                String mode = AbstractLaunchContextMainTab.this.getLaunchConfigurationDialog().getMode();
                if (typeId != null && mode != null) {
                    return LaunchConfigTypeBindingsManager.getInstance().isValidLaunchConfigType(typeId, mode, (ISelectionContext)new RemoteSelectionContext((IModelNode)((IPeerNode)element), true));
                }
            }
            return true;
        }
    }
}

