/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.flat;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.common.componentcore.internal.flat.AbstractFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class FilterResourceParticipant
extends AbstractFlattenParticipant {
    private IExportableResourceFilter filter;

    public static FilterResourceParticipant createSuffixFilterParticipant(String[] strings) {
        return new FilterResourceParticipant(new FilterExtensionsParticipant(strings));
    }

    public FilterResourceParticipant(IExportableResourceFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean shouldAddExportableFile(IVirtualComponent rootComponent, IVirtualComponent currentComponent, FlatVirtualComponent.FlatComponentTaskModel dataModel, IFlatFile file) {
        return this.filter.accepts(file);
    }

    public static class FilterExtensionsParticipant
    implements IExportableResourceFilter {
        private String[] bannedExtensions;

        public FilterExtensionsParticipant(String[] extensions) {
            this.bannedExtensions = extensions;
        }

        @Override
        public boolean accepts(IFlatResource resource) {
            IFile ifile = (IFile)resource.getAdapter(IFile.class);
            String name = null;
            if (ifile != null) {
                name = ifile.getName();
            } else {
                File f = (File)resource.getAdapter(File.class);
                if (f != null) {
                    name = f.getName();
                }
            }
            if (name != null) {
                int i = 0;
                while (i < this.bannedExtensions.length) {
                    if (name.endsWith(this.bannedExtensions[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
    }

    public static interface IExportableResourceFilter {
        public boolean accepts(IFlatResource var1);
    }
}

