/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.launching;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.core.model.IScript;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;

public final class SourceLookup {
    public static final QualifiedName SCRIPT_URL = new QualifiedName("org.eclipse.wst.jsdt.core", "scriptURL");
    public static final IPath TOP_LEVEL_PATH = new Path("/");

    public static String getSourceName(Object object) {
        String name = null;
        if (object instanceof IJavaScriptStackFrame) {
            name = ((IJavaScriptStackFrame)object).getSourceName();
        }
        if (object instanceof IScript) {
            name = URIUtil.lastSegment((URI)((IScript)object).sourceURI());
        }
        if (name != null) {
            if (new Path(name).getFileExtension() == null) {
                StringBuffer buf = new StringBuffer(name.length() + 3);
                buf.append(name).append('.').append("js");
                return buf.toString();
            }
            return name;
        }
        return null;
    }

    public static String getSource(Object sourceobj) {
        if (sourceobj instanceof IJavaScriptStackFrame) {
            IJavaScriptStackFrame jframe = (IJavaScriptStackFrame)sourceobj;
            return jframe.getSource();
        }
        if (sourceobj instanceof IScript) {
            IScript script = (IScript)sourceobj;
            return script.source();
        }
        return null;
    }

    public static URI getSourceURI(Object sourceobj) {
        if (sourceobj instanceof IJavaScriptStackFrame) {
            IJavaScriptStackFrame jframe = (IJavaScriptStackFrame)sourceobj;
            try {
                return new URI(jframe.getSourcePath());
            }
            catch (URISyntaxException uRISyntaxException) {
                try {
                    return URIUtil.fromString((String)jframe.getSourcePath());
                }
                catch (URISyntaxException e) {
                    JavaScriptDebugPlugin.log(e);
                }
            }
        }
        if (sourceobj instanceof IScript) {
            IScript script = (IScript)sourceobj;
            return script.sourceURI();
        }
        return null;
    }

    public static IFile getExternalSource(URI sourceuri, Object sourceobj) throws CoreException {
        String source = SourceLookup.getSource(sourceobj);
        if (source != null) {
            IPath path;
            IProject project = JavaScriptDebugPlugin.getExternalSourceProject(true);
            IFile file = project.getFile(path = SourceLookup.getSourcePath(sourceuri));
            if (!file.isAccessible()) {
                IProject folder = project;
                int i = 0;
                while (i < path.segmentCount() - 1) {
                    IFolder f = folder.getFolder((IPath)new Path(path.segment(i)));
                    if (!f.exists()) {
                        f.create(true, true, null);
                    }
                    folder = f;
                    ++i;
                }
                file = SourceLookup.doFormat(file, source);
            } else {
                file = SourceLookup.doFormat(file, source);
            }
            file.setPersistentProperty(SCRIPT_URL, sourceuri.toString());
            return file;
        }
        return null;
    }

    public static IPath getSourcePath(URI sourceuri) {
        String uripath = sourceuri.getPath();
        if (uripath == null) {
            return null;
        }
        if (uripath.trim().equals("/")) {
            uripath = "index.htm";
        }
        String host = sourceuri.getHost();
        Object path = null;
        if (host != null) {
            path = new Path(host);
        }
        path = path == null ? new Path(uripath) : path.append(uripath);
        return SourceLookup.adjustPath((IPath)path);
    }

    static IFile doFormat(IFile handle, String source) throws CoreException {
        if (handle.isAccessible()) {
            handle.setContents((InputStream)new ByteArrayInputStream(source.getBytes()), 1, null);
        } else {
            handle.create((InputStream)new ByteArrayInputStream(source.getBytes()), true, null);
        }
        return handle;
    }

    static IPath adjustPath(IPath path) {
        String segment = null;
        ArrayList<String> segments = new ArrayList<String>(path.segmentCount());
        int i = 0;
        while (i < path.segments().length) {
            segment = path.segment(i);
            if (i > 0 && i < path.segments().length - 1) {
                segment = segment.replaceAll("\\.js", "\\_js");
                if ((segment = segment.replaceAll("\\.html", "\\_html")).endsWith(".")) {
                    segment = String.valueOf(segment.substring(0, segment.length() - 1)) + '_';
                }
            }
            segments.add(segment);
            ++i;
        }
        Path newpath = new Path((String)segments.get(0));
        int i2 = 1;
        while (i2 < segments.size()) {
            newpath = newpath.append((String)segments.get(i2));
            ++i2;
        }
        String ext = newpath.getFileExtension();
        if (ext == null && !"js".equals(ext)) {
            newpath = newpath.addFileExtension("js");
        }
        return newpath;
    }
}

