/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.internal;

import java.io.File;
import java.util.function.Supplier;
import org.eclipse.jetty.ee8.nested.ContextHandler;
import org.eclipse.jetty.ee8.nested.Handler;
import org.eclipse.jetty.ee8.nested.ResourceHandler;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.wst.server.preview.internal.Module;
import org.eclipse.wst.server.preview.internal.ServerConfig;

public class PreviewStarter {
    protected String configPath;
    protected Server server;

    public PreviewStarter(String configPath) {
        this.configPath = configPath;
    }

    public static void main(String[] args) {
        PreviewStarter app = new PreviewStarter(args[0]);
        app.run();
    }

    protected void run() {
        try {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
            System.setProperty("VERBOSE", "true");
            ServerConfig config = new ServerConfig(this.configPath);
            System.out.println("Starting preview server on port " + config.getPort());
            System.out.println();
            this.server = new Server(config.getPort());
            this.server.setStopAtShutdown(true);
            System.out.println("Modules:");
            Module[] modules = config.getModules();
            ContextHandlerCollection handlers = new ContextHandlerCollection(new org.eclipse.jetty.server.handler.ContextHandler[0]);
            Module[] moduleArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                Module module = moduleArray[n2];
                System.out.println("  " + module.getName() + " (" + module.getContext() + ") ");
                if (module.isStaticWeb()) {
                    handler = new ResourceHandler();
                    File f = new File(module.getPath());
                    handler.setBaseResource(f.toPath());
                    handler.setDirAllowed(true);
                    handler.setDirectoriesListed(true);
                    handler.setWelcomeFiles(new String[]{"index.html", "welcome.html"});
                    handlers.addHandler((Supplier)new ContextHandler(module.getContext(), (Handler)handler));
                } else {
                    handler = new WebAppContext();
                    handler.setBaseResourceAsString(module.getPath());
                    handler.setContextPath(module.getContext());
                    handler.setParentLoaderPriority(true);
                    handler.setLogUrlOnStart(true);
                    handler.setWelcomeFiles(new String[]{"index.html", "welcome.html"});
                    handlers.addHandler((Supplier)handler);
                }
                ++n2;
            }
            this.server.setHandler((org.eclipse.jetty.server.Handler)handlers);
            handlers.setServer(this.server);
            System.out.println();
            this.server.start();
            this.server.join();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            System.out.println("Stop!");
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            File[] fileArray = files = directory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    PreviewStarter.deleteDirectory(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return directory.delete();
    }
}

