/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.internal.CMakeToolChainManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends Plugin {
    private static Activator plugin;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        bundleContext.registerService(ICMakeToolChainManager.class, (Object)new CMakeToolChainManager(), null);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
    }

    public static Activator getPlugin() {
        return plugin;
    }

    public static String getId() {
        return plugin.getBundle().getSymbolicName();
    }

    public static void log(Throwable e) {
        if (e instanceof CoreException) {
            plugin.getLog().log(((CoreException)e).getStatus());
        } else {
            plugin.getLog().log(Activator.errorStatus(e.getLocalizedMessage(), e));
        }
    }

    public static void error(String message, Throwable cause) {
        plugin.getLog().log(Activator.errorStatus(message, cause));
    }

    public static IStatus errorStatus(String message, Throwable cause) {
        return new Status(4, Activator.getId(), message, cause);
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = plugin.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

