/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.internal.derby.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbyCatalogSchema;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbyCatalogTable;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbySchemaLoader;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.modelbase.derby.impl.SynonymImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogSynonym
extends SynonymImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257804259579074800L;
    private Boolean columnsLoaded = Boolean.FALSE;
    private SoftReference columnLoaderRef;
    private Boolean aliasedTableLoaded = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (this.columnsLoaded.booleanValue()) {
                this.columnsLoaded = Boolean.FALSE;
            }
        }
        bl = this.aliasedTableLoaded;
        synchronized (bl) {
            if (this.aliasedTableLoaded.booleanValue()) {
                this.aliasedTableLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getColumns() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (!this.columnsLoaded.booleanValue()) {
                this.loadColumns();
            }
        }
        return this.columns;
    }

    protected JDBCTableColumnLoader createColumnLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLTablesPackage.eINSTANCE.getColumn().getInstanceClassName());
        if (loader != null) {
            JDBCTableColumnLoader tableColumnLoader = (JDBCTableColumnLoader)loader;
            tableColumnLoader.setCatalogObject((ICatalogObject)this);
            return tableColumnLoader;
        }
        return new JDBCTableColumnLoader((ICatalogObject)this);
    }

    protected final JDBCTableColumnLoader getColumnLoader() {
        if (this.columnLoaderRef == null || this.columnLoaderRef.get() == null) {
            this.columnLoaderRef = new SoftReference<JDBCTableColumnLoader>(this.createColumnLoader());
        }
        return (JDBCTableColumnLoader)this.columnLoaderRef.get();
    }

    private void loadColumns() {
        boolean deliver = this.eDeliver();
        try {
            try {
                EList container = super.getColumns();
                ArrayList existingColumns = new ArrayList(container);
                this.eSetDeliver(false);
                container.clear();
                this.getColumnLoader().loadColumns((List)container, existingColumns);
                this.getColumnLoader().clearColumns(existingColumns);
                this.columnsLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getColumns();
        } else if (id == 3) {
            this.getDescription();
        } else if (id == 18) {
            this.getAliasedTable();
        } else if (id == 8) {
            this.getColumns();
        } else if (id == 5) {
            return this.comments != null;
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getAliasedTable() {
        Boolean bl = this.aliasedTableLoaded;
        synchronized (bl) {
            if (!this.aliasedTableLoaded.booleanValue()) {
                this.loadAliasedTable();
            }
        }
        return this.table;
    }

    private Schema getSchema(String schemaName) {
        Schema s2 = this.getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database d = s2.getCatalog().getDatabase();
        for (Schema s2 : d.getSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        DerbyCatalogSchema schema = new DerbyCatalogSchema();
        schema.setName(schemaName);
        schema.setCatalog(s2.getCatalog());
        schema.setDatabase(d);
        return schema;
    }

    private Table getTable(String schemaName, String tableName) {
        DerbyCatalogTable table2;
        Schema schema = this.getSchema(schemaName);
        for (DerbyCatalogTable table2 : schema.getTables()) {
            if (!table2.getName().equals(tableName)) continue;
            return table2;
        }
        table2 = new DerbyCatalogTable();
        table2.setName(tableName);
        table2.setSchema(schema);
        return table2;
    }

    private synchronized void loadAliasedTable() {
        if (this.aliasedTableLoaded.booleanValue()) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT TABLENAME,TABLETYPE FROM SYS.SYSTABLES A,SYS.SYSSCHEMAS B WHERE A.SCHEMAID=B.SCHEMAID AND TABLETYPE='A'";
            Statement s = connection.createStatement();
            String currentSchema = DerbySchemaLoader.setSchema(s, "SYS");
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String tableName = r.getString("TABLENAME");
                this.setTable(this.getTable(this.getSchema().getName(), tableName));
                this.aliasedTableLoaded = Boolean.TRUE;
            }
            r.close();
            DerbySchemaLoader.setSchema(s, currentSchema);
            s.close();
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }
}

