/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.model;

/**
 * Contains the plugins informations for the project.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class PluginContainer
    implements java.io.Serializable, java.lang.Cloneable, org.apache.maven.model.InputLocationTracker
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field plugins.
     */
    private java.util.List<Plugin> plugins;

    /**
     * Field locations.
     */
    private java.util.Map<Object, InputLocation> locations;

    /**
     * Field location.
     */
    private InputLocation location;

    /**
     * Field pluginsLocation.
     */
    private InputLocation pluginsLocation;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin.
     * 
     * @param plugin a plugin object.
     */
    public void addPlugin( Plugin plugin )
    {
        getPlugins().add( plugin );
    } //-- void addPlugin( Plugin )

    /**
     * Method clone.
     * 
     * @return PluginContainer
     */
    public PluginContainer clone()
    {
        try
        {
            PluginContainer copy = (PluginContainer) super.clone();

            if ( this.plugins != null )
            {
                copy.plugins = new java.util.ArrayList<Plugin>();
                for ( Plugin item : this.plugins )
                {
                    copy.plugins.add( ( (Plugin) item).clone() );
                }
            }

            if ( copy.locations != null )
            {
                copy.locations = new java.util.LinkedHashMap( copy.locations );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- PluginContainer clone()

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    return this.location;
                }
                case "plugins" :
                {
                    return pluginsLocation;
                }
                default :
                {
                    return getOtherLocation( key );
                }
                }
            }
            else
            {
                return getOtherLocation( key );
            }
    } //-- InputLocation getLocation( Object )

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setLocation( Object key, InputLocation location )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    this.location = location;
                    return;
                }
                case "plugins" :
                {
                    pluginsLocation = location;
                    return;
                }
                default :
                {
                    setOtherLocation( key, location );
                    return;
                }
            }
        }
        else
        {
            setOtherLocation( key, location );
        }
    } //-- void setLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setOtherLocation( Object key, InputLocation location )
    {
        if ( location != null )
        {
            if ( this.locations == null )
            {
                this.locations = new java.util.LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put( key, location );
        }
    } //-- void setOtherLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    private InputLocation getOtherLocation( Object key )
    {
        return ( locations != null ) ? locations.get( key ) : null;
    } //-- InputLocation getOtherLocation( Object )

    /**
     * Method getPlugins.
     * 
     * @return List
     */
    public java.util.List<Plugin> getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList<Plugin>();
        }

        return this.plugins;
    } //-- java.util.List<Plugin> getPlugins()

    /**
     * Method removePlugin.
     * 
     * @param plugin a plugin object.
     */
    public void removePlugin( Plugin plugin )
    {
        getPlugins().remove( plugin );
    } //-- void removePlugin( Plugin )

    /**
     * Set the list of plugins to use.
     * 
     * @param plugins a plugins object.
     */
    public void setPlugins( java.util.List<Plugin> plugins )
    {
        this.plugins = plugins;
    } //-- void setPlugins( java.util.List )

    
            
    java.util.Map<String, Plugin> pluginMap;

    /**
     * Reset the <code>pluginsMap</code> field to <code>null</code>
     */
    public synchronized void flushPluginMap()
    {
        this.pluginMap = null;
    }

    /**
     * @return a Map of plugins field with <code>Plugins#getKey()</code> as key
     * @see org.apache.maven.model.Plugin#getKey()
     */
    public synchronized java.util.Map<String, Plugin> getPluginsAsMap()
    {
        if ( pluginMap == null )
        {
            pluginMap = new java.util.LinkedHashMap<String, Plugin>();
            if ( plugins != null )
            {
                for ( java.util.Iterator<Plugin> it = plugins.iterator(); it.hasNext(); )
                {
                    Plugin plugin = (Plugin) it.next();
                    pluginMap.put( plugin.getKey(), plugin );
                }
            }
        }

        return pluginMap;
    }
            
          
    
            
     @Override
     public String toString()
     {
         return "PluginContainer {}";
     }
            
          
}
