/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.asm.lib;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.Messages;
import org.eclipse.m2m.atl.engine.emfvm.ASMOperation;
import org.eclipse.m2m.atl.engine.emfvm.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;
import org.eclipse.m2m.atl.engine.emfvm.lib.Tuple;

public class SOTSExpression2 {
    private static String[] tokenNames = new String[]{"EOF", "DOT", "COMA", "EXCL", "EQ", "PLUS", "LSQUARE", "RSQUARE", "LPAREN", "RPAREN", "INT", "STRING", "IDENT", "ISA"};
    protected String exp;
    private Reader in;
    private Token readAhead = null;

    public SOTSExpression2(String exp) {
        this.exp = exp;
        this.in = new StringReader(exp);
    }

    public Object exec(StackFrame frame, Tuple args) throws IOException {
        return this.exp(frame, args);
    }

    private Object exp(StackFrame frame, Tuple args) throws IOException {
        Object ret = null;
        Token t = null;
        t = this.next();
        if (t.type == 8) {
            ret = this.exp(frame, args);
            this.match(9);
            return ret;
        }
        if (t.type == 11 || t.type == 10) {
            ret = this.convValue(t);
        } else {
            this.unread(t);
            ret = this.simpleExp(frame, args);
        }
        t = this.next();
        if (t.type == 5) {
            Object right = this.exp(frame, args);
            if (right == null) {
                ret = null;
            } else if (ret instanceof Integer) {
                ret = new Integer((Integer)ret + (Integer)right);
            } else if (ret instanceof String) {
                ret = String.valueOf((String)ret) + right.toString();
            } else {
                ATLLogger.severe((String)Messages.getString("SOTSExpression2_TYPE", new Object[]{ret.getClass()}));
            }
        } else {
            this.unread(t);
        }
        return ret;
    }

    private Object simpleExp(StackFrame frame, Tuple args) throws IOException {
        Token t = null;
        ArrayList<Object> ret = null;
        t = this.match(12);
        ret = args.get((AbstractStackFrame)frame, (Object)t.value);
        boolean done = false;
        block6: do {
            t = this.next();
            Object var6_7 = null;
            ArrayList<Object> col = null;
            Object value = null;
            switch (t.type) {
                case 0: {
                    done = true;
                    break;
                }
                case 1: {
                    t = this.next();
                    if (t.type != 12 && t.type != 11) {
                        this.error(t);
                    }
                    ret = this.toCollection(ret);
                    col = new ArrayList();
                    Token n = this.next();
                    if (n.type == 8) {
                        this.match(9);
                        for (Object o : (Collection)ret) {
                            EClass type = null;
                            type = o instanceof EObject ? ((EObject)o).eClass() : o.getClass();
                            Operation oper = frame.getExecEnv().getOperation((Object)type, (Object)t.value);
                            if (oper != null) {
                                Object v = null;
                                StackFrame calleeFrame = (StackFrame)frame.newFrame(oper);
                                Object[] arguments = calleeFrame.getLocalVars();
                                arguments[0] = o;
                                v = oper instanceof ASMOperation ? ((ASMOperation)oper).exec((AbstractStackFrame)calleeFrame, null) : oper.exec((AbstractStackFrame)calleeFrame);
                                col.add(v);
                                continue;
                            }
                            throw new VMException((AbstractStackFrame)frame, Messages.getString("SOTSExpression2_OPERATION", new Object[]{t.value, o}));
                        }
                    } else {
                        this.unread(n);
                        for (EObject eObject : (ArrayList)ret) {
                            if (t.type == 12) {
                                EStructuralFeature f = eObject.eClass().getEStructuralFeature(t.value);
                                Object v = eObject.eGet(f);
                                if (v == null) continue;
                                col.add(v);
                                continue;
                            }
                            col.add(new String(t.value));
                        }
                    }
                    ret = this.flatten(col);
                    break;
                }
                case 2: {
                    if (ret != null && (!(ret instanceof ArrayList) || ((ArrayList)ret).size() != 0)) continue block6;
                    value = this.exp(frame, args);
                    ret = value;
                    break;
                }
                case 6: {
                    t = this.next();
                    ret = this.toCollection(ret);
                    col = new ArrayList<Object>();
                    if (t.type == 13) {
                        this.match(8);
                        String mname = this.match((int)12).value;
                        this.match(3);
                        String mename = this.match((int)12).value;
                        this.match(9);
                        String expectedTypeName = String.valueOf(mname) + "!" + mename;
                        for (EObject eObject : ret) {
                            String typeName = eObject.eClass().getName();
                            if (!typeName.equals(expectedTypeName)) continue;
                            col.add(eObject);
                        }
                        ret = col;
                    } else if (t.type == 10) {
                        this.unread(t);
                        this.exp(frame, args);
                        ret = ((ArrayList)ret).size() > 0 ? ((ArrayList)ret).iterator().next() : null;
                    } else {
                        if (t.type != 12) {
                            this.error(t);
                        }
                        String propName = t.value;
                        this.match(4);
                        value = this.exp(frame, args);
                        for (EObject eObject : (Collection)ret) {
                            EStructuralFeature f;
                            if (!eObject.eGet(f = eObject.eClass().getEStructuralFeature(propName)).equals(value)) continue;
                            col.add(eObject);
                        }
                        ret = col;
                    }
                    this.match(7);
                    break;
                }
                default: {
                    this.unread(t);
                    done = true;
                }
            }
        } while (!done);
        return ret;
    }

    private Object toCollection(Object value) {
        ArrayList<Object> ret = null;
        if (value instanceof ArrayList) {
            ret = (ArrayList<Object>)value;
        } else {
            Object elem = value;
            ret = new ArrayList<Object>();
            if (elem != null) {
                ret.add(elem);
            }
        }
        return ret;
    }

    private Object convValue(Token value) {
        Object ret = null;
        ret = value.type == 10 ? new Integer(Integer.parseInt(value.value)) : new String(value.value);
        return ret;
    }

    private void error(Token t) throws IOException {
        throw new IOException(Messages.getString("SOTSExpression2_UNEXPECTED", new Object[]{t}));
    }

    private Token match(int type) throws IOException {
        Token ret = this.next();
        if (ret.type != type) {
            this.error(ret);
        }
        return ret;
    }

    private void unread(Token t) {
        this.readAhead = t;
    }

    private Token next() throws IOException {
        Token ret = null;
        String value = "";
        if (this.readAhead != null) {
            Token tmp = this.readAhead;
            this.readAhead = null;
            return tmp;
        }
        int c = this.in.read();
        switch (c) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                do {
                    this.in.mark(1);
                } while ((c = this.in.read()) == 32 || c == 9 || c == 10 || c == 13);
                this.in.reset();
                ret = this.next();
                break;
            }
            case -1: {
                ret = new Token(0, "<EOF>");
                break;
            }
            case 46: {
                ret = new Token(1, ".");
                break;
            }
            case 44: {
                ret = new Token(2, ",");
                break;
            }
            case 33: {
                ret = new Token(3, "!");
                break;
            }
            case 61: {
                ret = new Token(4, "=");
                break;
            }
            case 43: {
                ret = new Token(5, "+");
                break;
            }
            case 91: {
                ret = new Token(6, "[");
                break;
            }
            case 93: {
                ret = new Token(7, "]");
                break;
            }
            case 40: {
                ret = new Token(8, "(");
                break;
            }
            case 41: {
                ret = new Token(9, ")");
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                do {
                    value = String.valueOf(value) + (char)c;
                    this.in.mark(1);
                } while ((c = this.in.read()) >= 48 && c <= 57);
                this.in.reset();
                ret = new Token(10, value);
                break;
            }
            case 39: {
                while ((c = this.in.read()) != 39) {
                    value = String.valueOf(value) + (char)c;
                }
                ret = new Token(11, value);
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: {
                do {
                    value = String.valueOf(value) + (char)c;
                    this.in.mark(1);
                } while ((c = this.in.read()) >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95);
                this.in.reset();
                if (value.equals("ISA")) {
                    ret = new Token(13, value);
                    break;
                }
                ret = new Token(12, value);
                break;
            }
            case 36: {
                ret = this.next();
                break;
            }
            default: {
                ATLLogger.severe((String)Messages.getString("SOTSExpression2_UNEXPECTED_CHAR", new Object[]{new Character((char)c)}));
            }
        }
        return ret;
    }

    private Collection flatten(Collection coll) {
        boolean containsCollection;
        ArrayList base = null;
        do {
            base = coll;
            coll = new ArrayList();
            containsCollection = false;
            for (Object object : base) {
                if (object instanceof Collection) {
                    Collection subCollection = (Collection)object;
                    coll.addAll(subCollection);
                    Iterator iterator2 = subCollection.iterator();
                    while (!containsCollection && iterator2.hasNext()) {
                        Object subCollectionObject = iterator2.next();
                        if (!(subCollectionObject instanceof Collection)) continue;
                        containsCollection = true;
                    }
                    continue;
                }
                coll.add(object);
            }
        } while (containsCollection);
        return coll;
    }

    private class Token {
        public static final int EOF = 0;
        public static final int DOT = 1;
        public static final int COMA = 2;
        public static final int EXCL = 3;
        public static final int EQ = 4;
        public static final int PLUS = 5;
        public static final int LSQUARE = 6;
        public static final int RSQUARE = 7;
        public static final int LPAREN = 8;
        public static final int RPAREN = 9;
        public static final int INT = 10;
        public static final int STRING = 11;
        public static final int IDENT = 12;
        public static final int ISA = 13;
        public int type;
        public String value;

        public Token(int type, String value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return String.valueOf(tokenNames[this.type]) + ":" + this.value;
        }
    }
}

