/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone.validity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporterDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.export.ValidityExporterRegistry;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.examples.standalone.messages.StandaloneMessages;
import org.eclipse.ocl.examples.standalone.validity.StandaloneValidityManager;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.xtext.completeocl.utilities.CompleteOCLLoader;

public class ValidateCommand
extends StandaloneCommand {
    private static final Logger logger = Logger.getLogger(ValidateCommand.class);
    public final @NonNull ExporterToken exporterToken;
    public final @NonNull ModelToken modelToken;
    public final @NonNull StandaloneCommand.OutputToken outputToken;
    public final @NonNull RulesToken rulesToken;
    public final @NonNull UsingToken usingToken;

    private static URI getFileUri(@NonNull String fileName) {
        try {
            File file = new File(fileName).getCanonicalFile();
            Path filePath = new Path(file.getAbsolutePath());
            URI fileUri = ValidateCommand.isRelativePath((IPath)filePath) ? URI.createPlatformResourceURI((String)filePath.toString(), (boolean)true) : URI.createFileURI((String)filePath.toString());
            return fileUri;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isRelativePath(IPath path) {
        if (ResourcesPlugin.getPlugin() != null) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            return resource != null && resource.exists();
        }
        return false;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    public ValidateCommand(@NonNull StandaloneApplication standaloneApplication) {
        super(standaloneApplication, "validate", StandaloneMessages.ValidateCommand_Help);
        this.exporterToken = new ExporterToken(this.standaloneApplication);
        this.modelToken = new ModelToken(this.standaloneApplication);
        this.outputToken = new StandaloneCommand.OutputToken(this.standaloneApplication);
        this.rulesToken = new RulesToken(this.standaloneApplication);
        this.usingToken = new UsingToken(this.standaloneApplication);
        this.modelToken.setIsRequired();
        this.rulesToken.setIsRequired();
        this.addToken(this.modelToken);
        this.addToken(this.rulesToken);
        this.addToken(this.outputToken);
        this.addToken(this.exporterToken);
        this.addToken(this.usingToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull StandaloneResponse execute() {
        Resource modelResource;
        this.standaloneApplication.doCompleteOCLSetup();
        String modelFileName = this.modelToken.getModelFileName();
        List<String> oclFileNames = this.rulesToken.getOCLFileNames();
        URI modelURI = URI.createURI((String)modelFileName, (boolean)true);
        if (!modelURI.isPlatform()) {
            modelURI = ValidateCommand.getFileUri(modelFileName);
        }
        if ((modelResource = this.standaloneApplication.loadModelFile(modelURI)) == null) {
            logger.error((Object)MessageFormat.format(StandaloneMessages.OCLValidatorApplication_ModelLoadProblem, modelFileName));
            return StandaloneResponse.FAIL;
        }
        if (!this.processResources(modelFileName, oclFileNames)) {
            logger.error((Object)StandaloneMessages.OCLValidatorApplication_Aborted);
            return StandaloneResponse.FAIL;
        }
        if (ThreadLocalExecutor.basicGetEnvironmentFactory() == null) {
            logger.error((Object)StandaloneMessages.OCLValidatorApplication_Aborted);
            return StandaloneResponse.FAIL;
        }
        StandaloneValidityManager validityManager = this.initiateValidityManager(this.standaloneApplication.getResourceSet());
        if (validityManager != null) {
            Thread validationThread = new Thread((Runnable)new ValidationRunnable(validityManager), "Standalone Validation");
            validationThread.start();
            Thread thread = validationThread;
            synchronized (thread) {
                try {
                    validationThread.wait(1000000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            File outputFile = this.outputToken.getOutputFile();
            this.exportValidationResults(validityManager.getRootNode(), outputFile);
        }
        return StandaloneResponse.OK;
    }

    private void exportValidationResults(@NonNull RootNode rootNode, @Nullable File outputFile) {
        block13: {
            IValidityExporter selectedExporter = this.exporterToken.getExporter();
            if (selectedExporter != null && rootNode != null) {
                Appendable s = null;
                try {
                    try {
                        s = outputFile != null ? new FileWriter(outputFile) : DEFAULT_OUTPUT_STREAM;
                        selectedExporter.export(s, rootNode, outputFile != null ? outputFile.toString() : null);
                    }
                    catch (IOException e) {
                        logger.error((Object)StandaloneMessages.OCLValidatorApplication_ExportProblem, (Throwable)e);
                        if (s == DEFAULT_OUTPUT_STREAM || !(s instanceof OutputStreamWriter)) break block13;
                        try {
                            ((OutputStreamWriter)s).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (s != DEFAULT_OUTPUT_STREAM && s instanceof OutputStreamWriter) {
                        try {
                            ((OutputStreamWriter)s).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private @NonNull StandaloneValidityManager initiateValidityManager(@NonNull ResourceSet resourceSet) {
        StandaloneValidityManager validityManager = new StandaloneValidityManager();
        validityManager.setRunJavaConstraints(this.usingToken.doRunJavaConstraints());
        validityManager.setRunOCLConstraints(this.usingToken.doRunOCLConstraints());
        validityManager.setRunUMLConstraints(this.usingToken.doRunUMLConstraints());
        validityManager.setInput(resourceSet);
        return validityManager;
    }

    private boolean processResources(@NonNull String modelFilePath, @NonNull List<String> oclFileNames) {
        boolean allOk = true;
        CompleteOCLLoader helper = new CompleteOCLLoader(this.standaloneApplication.getEnvironmentFactory()){

            protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
                logger.error((Object)(String.valueOf(primaryMessage) + detailMessage));
                return false;
            }
        };
        for (String oclFileName : oclFileNames) {
            URI oclURI = URI.createURI((String)oclFileName, (boolean)true);
            if (!oclURI.isPlatform()) {
                oclURI = ValidateCommand.getFileUri(oclFileName);
            }
            if (allOk && oclURI == null) {
                logger.error((Object)MessageFormat.format(StandaloneMessages.OCLValidatorApplication_OclUriProblem, oclFileName));
                allOk = false;
            }
            try {
                Resource oclResource;
                if (!allOk || (oclResource = helper.loadResource(oclURI)) != null) continue;
                logger.error((Object)MessageFormat.format(StandaloneMessages.OCLValidatorApplication_OclLoadProblem, oclFileName));
                allOk = false;
            }
            catch (Throwable e) {
                logger.error((Object)MessageFormat.format(StandaloneMessages.OCLValidatorApplication_OclLoadProblem, oclFileName));
                allOk = false;
            }
        }
        if (allOk && !helper.loadMetamodels()) {
            logger.error((Object)StandaloneMessages.OCLValidatorApplication_MetamodelsLoadProblem);
            allOk = false;
        }
        helper.installPackages();
        helper.dispose();
        return allOk;
    }

    protected static final class ExporterComparator
    implements Comparator<IValidityExporterDescriptor> {
        public static final @NonNull ExporterComparator INSTANCE = new ExporterComparator();

        protected ExporterComparator() {
        }

        @Override
        public int compare(IValidityExporterDescriptor o1, IValidityExporterDescriptor o2) {
            String n1 = o1.getExporterType();
            String n2 = o2.getExporterType();
            return n1.compareTo(n2);
        }
    }

    public static class ExporterToken
    extends StandaloneCommand.StringToken {
        private @Nullable IValidityExporter exporter;

        public ExporterToken(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication, "-exporter", StandaloneMessages.ValidateCommand_Exporter_Help, "<later>");
        }

        @Override
        public @Nullable String getArgumentsHelp() {
            ArrayList exporters = new ArrayList(ValidityExporterRegistry.INSTANCE.getRegisteredExtensions());
            Collections.sort(exporters, ExporterComparator.INSTANCE);
            StringBuilder s = new StringBuilder();
            for (IValidityExporterDescriptor exporter : exporters) {
                if (s.length() > 0) {
                    s.append("|");
                }
                s.append(exporter.getExporterType());
            }
            return s.toString();
        }

        public @Nullable IValidityExporter getExporter() {
            return this.exporter;
        }

        @Override
        public int getMaxArguments() {
            return 1;
        }

        @Override
        public boolean parseCheck(@NonNull String string) {
            this.exporter = ValidityExporterRegistry.INSTANCE.getExporter(string);
            if (this.exporter == null) {
                logger.error((Object)("Unrecognized 'exporter' " + string));
                return false;
            }
            return true;
        }
    }

    public static class ModelToken
    extends StandaloneCommand.StringToken {
        private @Nullable String fileName;

        public ModelToken(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication, "-model", StandaloneMessages.ValidateCommand_Model_Help, "<file-name>");
        }

        @Override
        public boolean analyze(@Nullable String string) {
            URI uri = URI.createURI((String)string);
            this.fileName = uri.isFile() ? uri.toFileString() : string;
            boolean exists = this.standaloneApplication.getURIConverter().exists(uri, null);
            if (!exists) {
                logger.error((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_ModelFile) + uri + StandaloneMessages.OCLArgumentAnalyzer_NotExist));
                return false;
            }
            return true;
        }

        public @Nullable String getModelFileName() {
            return this.fileName;
        }
    }

    public static class RulesToken
    extends StandaloneCommand.CommandToken {
        private static final Object TEXT_FILE_EXTENSION = "txt";
        private static final Object OCL_FILE_EXTENSION = "ocl";
        private @Nullable List<@NonNull String> oclFileNames;

        public RulesToken(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication, "-rules", StandaloneMessages.ValidateCommand_Rules_Help, "<file-name>");
        }

        @Override
        public boolean analyze(@Nullable String string) {
            URI uri = URI.createURI((String)string);
            URIConverter uriConverter = this.standaloneApplication.getURIConverter();
            ArrayList<@NonNull String> strings = new ArrayList<String>();
            this.checkOclFile(uriConverter, strings, uri.toString());
            List<@NonNull String> oclFileNames2 = this.oclFileNames;
            if (oclFileNames2 == null) {
                this.oclFileNames = oclFileNames2 = new ArrayList<String>();
            }
            oclFileNames2.addAll(strings);
            return true;
        }

        private void checkOclFile(@NonNull URIConverter uriConverter, @NonNull List<String> strings, @NonNull String argument) {
            URI uri = URI.createURI((String)argument);
            argument = uri.isFile() ? uri.toFileString() : argument;
            boolean ignored = false;
            boolean exists = uriConverter.exists(uri, null);
            String fileExtension = uri.fileExtension();
            if (TEXT_FILE_EXTENSION.equals(fileExtension.toLowerCase())) {
                this.extractOCLUris(uriConverter, strings, uri);
            } else if (OCL_FILE_EXTENSION.equals(fileExtension.toLowerCase())) {
                if (!exists) {
                    logger.warn((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_OCLResource) + " " + uri + StandaloneMessages.OCLArgumentAnalyzer_NotExist));
                    ignored = true;
                } else {
                    strings.add(uri.toString());
                }
            } else {
                logger.warn((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_FileExt) + uri.lastSegment() + StandaloneMessages.OCLArgumentAnalyzer_ExtensionPb));
                ignored = true;
            }
            if (ignored) {
                logger.warn((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_OCLFile) + " " + uri + StandaloneMessages.OCLArgumentAnalyzer_ignored));
            }
        }

        private void extractOCLUris(@NonNull URIConverter uriConverter, @NonNull List<@NonNull String> strings, @NonNull URI txtURI) {
            try {
                InputStream inputStream = uriConverter.createInputStream(txtURI);
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line = reader.readLine();
                while (line != null) {
                    URI childURI = URI.createURI((String)line).resolve(txtURI);
                    this.checkOclFile(uriConverter, strings, childURI.toString());
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
                logger.error((Object)MessageFormat.format(StandaloneMessages.OCLArgumentAnalyzer_OCLFileNotFound, txtURI));
            }
            catch (IOException e) {
                logger.warn((Object)e.getMessage());
            }
        }

        public @NonNull List<String> getOCLFileNames() {
            return this.oclFileNames != null ? this.oclFileNames : Collections.emptyList();
        }
    }

    public static class UsingToken
    extends StandaloneCommand.StringToken {
        private static final @NonNull String ALL_LOCATORS = "all";
        private static final @NonNull String OCL_LOCATOR = "ocl";
        private static final @NonNull String JAVA_LOCATOR = "java";
        private static final @NonNull String UML_LOCATOR = "uml";
        private boolean doJava = false;
        private boolean doOCL = false;
        private boolean doUML = false;

        public UsingToken(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication, "-using", StandaloneMessages.ValidateCommand_Using_Help, "all|java|ocl|uml");
        }

        public boolean doRunJavaConstraints() {
            return this.doJava || !this.doJava && !this.doOCL && !this.doUML;
        }

        public boolean doRunOCLConstraints() {
            return this.doOCL || !this.doJava && !this.doOCL && !this.doUML;
        }

        public boolean doRunUMLConstraints() {
            return this.doUML || !this.doJava && !this.doOCL && !this.doUML;
        }

        @Override
        public int getMaxArguments() {
            return -1;
        }

        @Override
        public boolean isSingleton() {
            return false;
        }

        @Override
        public boolean parseCheck(@NonNull String string) {
            String[] locators;
            boolean okLocators = true;
            String[] stringArray = locators = string.split(",");
            int n = locators.length;
            int n2 = 0;
            while (n2 < n) {
                String locator = stringArray[n2];
                if (ALL_LOCATORS.equals(locator)) {
                    this.doJava = true;
                    this.doOCL = true;
                    this.doUML = true;
                } else if (JAVA_LOCATOR.equals(locator)) {
                    this.doJava = true;
                } else if (OCL_LOCATOR.equals(locator)) {
                    this.doOCL = true;
                } else if (UML_LOCATOR.equals(locator)) {
                    this.doUML = true;
                } else {
                    logger.error((Object)("Unknown locator '" + locator + "'"));
                    okLocators = false;
                }
                ++n2;
            }
            return okLocators;
        }
    }

    protected class ValidationRunnable
    implements Runnable {
        private final StandaloneValidityManager validityManager;

        protected ValidationRunnable(StandaloneValidityManager validityManager) {
            this.validityManager = validityManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.validityManager.runValidation(null, null);
            }
            catch (Throwable throwable) {
                ValidationRunnable validationRunnable = this;
                synchronized (validationRunnable) {
                    this.notify();
                }
                throw throwable;
            }
            ValidationRunnable validationRunnable = this;
            synchronized (validationRunnable) {
                this.notify();
            }
        }
    }
}

