/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.tool.internal.validation.description.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.sequence.description.FrameMapping;
import org.eclipse.sirius.diagram.sequence.description.OperandMapping;

public class SequenceContainerMappingChildrenPresentationConstraints
extends AbstractModelConstraint {
    public static final String SEQUENCE_NO_REGION_RULE_ID = "org.eclipse.sirius.diagram.sequence.NoSequenceContainerRegionChildrenPresentation";

    public IStatus validate(IValidationContext ctx) {
        IStatus result = ctx.createSuccessStatus();
        EObject eObj = ctx.getTarget();
        if (eObj instanceof ContainerMapping) {
            ContainerMapping containerMapping = (ContainerMapping)eObj;
            if (SEQUENCE_NO_REGION_RULE_ID.equals(ctx.getCurrentConstraintId())) {
                result = this.validateNoRegionContainerMapping(ctx, containerMapping);
            }
        }
        return result;
    }

    private IStatus validateNoRegionContainerMapping(IValidationContext ctx, ContainerMapping containerMapping) {
        if ((containerMapping instanceof FrameMapping || containerMapping instanceof OperandMapping) && new ContainerMappingQuery(containerMapping).isRegionContainer()) {
            return ctx.createFailureStatus(new Object[]{containerMapping});
        }
        return ctx.createSuccessStatus();
    }
}

