/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.declaration.AbstractElementImpl;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.ProblemImpl;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.services.Problem;
import org.eclipse.xtend.lib.macro.services.ProblemSupport;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ProblemSupportImpl
implements ProblemSupport {
    private CompilationUnitImpl compilationUnit;
    private final List<Procedures.Procedure0> delayedTasks = CollectionLiterals.newArrayList();

    public ProblemSupportImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    private void checkCanceled() {
        this.compilationUnit.checkCanceled();
    }

    private void checkValidationAllowed() {
        boolean _greaterThan;
        ActiveAnnotationContexts.AnnotationCallback _lastPhase = this.compilationUnit.getLastPhase();
        boolean bl = _greaterThan = _lastPhase.compareTo(ActiveAnnotationContexts.AnnotationCallback.VALIDATION) > 0;
        if (_greaterThan) {
            throw new IllegalStateException("Adding problems is not allowed after the validation phase");
        }
    }

    public void addError(Element element, String message) {
        this.checkCanceled();
        this.checkValidationAllowed();
        Pair<Resource, EObject> resAndObj = this.getResourceAndEObject(element);
        EList _errors = ((Resource)resAndObj.getKey()).getErrors();
        EObject _value = (EObject)resAndObj.getValue();
        EStructuralFeature _significantFeature = this.getSignificantFeature((EObject)resAndObj.getValue());
        EObjectDiagnosticImpl _eObjectDiagnosticImpl = new EObjectDiagnosticImpl(Severity.ERROR, "user.issue", message, _value, _significantFeature, -1, null);
        _errors.add((Object)_eObjectDiagnosticImpl);
    }

    public void addWarning(Element element, String message) {
        this.checkCanceled();
        this.checkValidationAllowed();
        Pair<Resource, EObject> resAndObj = this.getResourceAndEObject(element);
        EList _warnings = ((Resource)resAndObj.getKey()).getWarnings();
        EObject _value = (EObject)resAndObj.getValue();
        EStructuralFeature _significantFeature = this.getSignificantFeature((EObject)resAndObj.getValue());
        EObjectDiagnosticImpl _eObjectDiagnosticImpl = new EObjectDiagnosticImpl(Severity.WARNING, "user.issue", message, _value, _significantFeature, -1, null);
        _warnings.add((Object)_eObjectDiagnosticImpl);
    }

    public void validateLater(Procedures.Procedure0 validationCallback) {
        boolean _lessThan;
        ActiveAnnotationContexts.AnnotationCallback _lastPhase = this.compilationUnit.getLastPhase();
        boolean bl = _lessThan = _lastPhase.compareTo(ActiveAnnotationContexts.AnnotationCallback.VALIDATION) < 0;
        if (_lessThan) {
            this.delayedTasks.add(validationCallback);
        } else {
            validationCallback.apply();
        }
    }

    public void validationPhaseStarted() {
        try {
            try {
                Consumer<Procedures.Procedure0> _function = it -> it.apply();
                this.delayedTasks.forEach(_function);
            }
            catch (Throwable _t) {
                if (!(_t instanceof Throwable)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                Throwable t = _t;
                this.compilationUnit.handleProcessingError(Collections.singleton(this.compilationUnit.getXtendFile()), this.compilationUnit.getXtendFile().eResource(), t);
                this.delayedTasks.clear();
            }
        }
        finally {
            this.delayedTasks.clear();
        }
    }

    public List<? extends Problem> getProblems(Element element) {
        this.checkCanceled();
        Pair<Resource, EObject> resAndObj = this.getResourceAndEObject(element);
        Resource resource = (Resource)resAndObj.getKey();
        EList _errors = resource.getErrors();
        EList _warnings = resource.getWarnings();
        Iterable issues = Iterables.filter((Iterable)Iterables.concat((Iterable)_errors, (Iterable)_warnings), EObjectDiagnosticImpl.class);
        Functions.Function1 _function = diag -> {
            EObject _problematicObject = diag.getProblematicObject();
            EObject _value = (EObject)resAndObj.getValue();
            return Objects.equals(_problematicObject, _value);
        };
        Functions.Function1 _function_1 = diag -> {
            String _code = diag.getCode();
            String _message = diag.getMessage();
            Problem.Severity _translateSeverity = this.translateSeverity(diag.getSeverity());
            ProblemImpl _problemImpl = new ProblemImpl(_code, _message, _translateSeverity);
            return _problemImpl;
        };
        Iterable result = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)issues, (Functions.Function1)_function), (Functions.Function1)_function_1);
        return IterableExtensions.toList((Iterable)result);
    }

    public EStructuralFeature getSignificantFeature(EObject obj) {
        EAttribute _switchResult = null;
        boolean _matched = false;
        if (obj instanceof XtendTypeDeclaration) {
            _matched = true;
            _switchResult = XtendPackage.eINSTANCE.getXtendTypeDeclaration_Name();
        }
        if (!_matched && obj instanceof XtendField) {
            _matched = true;
            _switchResult = XtendPackage.eINSTANCE.getXtendField_Name();
        }
        if (!_matched && obj instanceof XtendFunction) {
            _matched = true;
            _switchResult = XtendPackage.eINSTANCE.getXtendFunction_Name();
        }
        if (!_matched && obj instanceof JvmFormalParameter) {
            _matched = true;
            _switchResult = TypesPackage.eINSTANCE.getJvmFormalParameter_Name();
        }
        if (!_matched && obj instanceof XAnnotation) {
            _matched = true;
            _switchResult = XAnnotationsPackage.eINSTANCE.getXAnnotation_AnnotationType();
        }
        return _switchResult;
    }

    private Pair<Resource, EObject> getResourceAndEObject(Element element) {
        boolean _equals;
        this.checkCanceled();
        boolean _matched = false;
        if (element instanceof CompilationUnitImpl && (_equals = Objects.equals(element, this.compilationUnit))) {
            _matched = true;
            Resource _eResource = this.compilationUnit.getXtendFile().eResource();
            XtendFile _xtendFile = this.compilationUnit.getXtendFile();
            return Pair.of((Object)_eResource, (Object)_xtendFile);
        }
        if (!_matched && element instanceof AbstractElementImpl) {
            Resource _eResource;
            _matched = true;
            Resource resource = ((EObject)((AbstractElementImpl)element).getDelegate()).eResource();
            boolean _equals2 = Objects.equals(resource, _eResource = this.compilationUnit.getXtendFile().eResource());
            if (_equals2) {
                EObject eobject = this.compilationUnit.getJvmModelAssociations().getPrimarySourceElement((EObject)((AbstractElementImpl)element).getDelegate());
                if (eobject == null) {
                    EObject _delegate = (EObject)((AbstractElementImpl)element).getDelegate();
                    return Pair.of((Object)resource, (Object)_delegate);
                }
                return Pair.of((Object)resource, (Object)eobject);
            }
        }
        throw new IllegalArgumentException("You can only add issues on locally declared elements.");
    }

    private Problem.Severity translateSeverity(Severity severity) {
        Problem.Severity _switchResult = null;
        if (severity != null) {
            switch (severity) {
                case ERROR: {
                    _switchResult = Problem.Severity.ERROR;
                    break;
                }
                case WARNING: {
                    _switchResult = Problem.Severity.WARNING;
                    break;
                }
                case INFO: {
                    _switchResult = Problem.Severity.INFO;
                    break;
                }
                case IGNORE: {
                    _switchResult = Problem.Severity.IGNORE;
                    break;
                }
            }
        }
        return _switchResult;
    }
}

