/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import java.util.List;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class IrqExitHandler
extends KernelEventHandler {
    public IrqExitHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        if (cpu == null) {
            return;
        }
        int currentThreadNode = KernelEventHandlerUtils.getCurrentThreadNode(cpu, ss);
        Integer irqId = ((Long)event.getContent().getField(new String[]{this.getLayout().fieldIrq()}).getValue()).intValue();
        List subAttrs = ss.getSubAttributes(KernelEventHandlerUtils.getNodeIRQs(cpu, ss), false);
        String irqPrefix = irqId.toString() + "/";
        List<Integer> quarks = subAttrs.stream().filter(iquark -> ss.getAttributeName(iquark.intValue()).startsWith(irqPrefix)).toList();
        int quark = -2;
        for (int quarkCandidate : quarks) {
            if (ss.queryOngoing(quarkCandidate) == null) continue;
            quark = quarkCandidate;
            break;
        }
        String name = ss.getAttributeName(quark);
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        ss.modifyAttribute(timestamp, null, quark);
        KernelEventHandlerUtils.setProcessToRunning(timestamp, currentThreadNode, ss);
        KernelEventHandlerUtils.updateCpuStatus(timestamp, cpu, ss);
        int aggregateQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"IRQs", name});
        Integer prevCpu = KernelEventHandlerUtils.getCpuForIrq(ss, irqId);
        ss.modifyAttribute(timestamp, (Object)prevCpu, aggregateQuark);
    }
}

