/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.GenericPropertySetValue;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.order.MethodOrder;
import org.eclipse.wb.internal.core.model.order.MethodOrderBeforeAssociation;
import org.eclipse.wb.internal.core.model.order.MethodOrderDefault;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.variable.AbstractNamedVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalVariableSupport;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.model.variable.VariableUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;

public abstract class AbstractSimpleVariableSupport
extends AbstractNamedVariableSupport {
    private final AbstractSimpleVariableSupport m_this = this;
    protected final VariableUtils m_utils = new VariableUtils(this.m_javaInfo);

    public AbstractSimpleVariableSupport(JavaInfo javaInfo) {
        this(javaInfo, null);
    }

    public AbstractSimpleVariableSupport(JavaInfo javaInfo, Expression variable) {
        super(javaInfo, variable);
        this.hookTextRenameEvent();
    }

    @Override
    public boolean hasExpression(NodeTarget target) {
        return JavaInfoUtils.isCreatedAtTarget(this.m_javaInfo, target);
    }

    @Override
    public StatementTarget getStatementTarget() throws Exception {
        Statement assignmentStatement = AstNodeUtils.getEnclosingStatement((ASTNode)this.m_variable);
        return new StatementTarget(assignmentStatement, false);
    }

    @Override
    public void ensureInstanceReadyAt(StatementTarget target) throws Exception {
        this.moveStatements(target);
    }

    @Override
    public StatementTarget getAssociationTarget(StatementTarget target) throws Exception {
        StatementTarget associationTarget = this.getAssociationTarget_beforeAssocitation();
        if (associationTarget != null) {
            return associationTarget;
        }
        return this.getStatementTarget();
    }

    protected final void assertJavaInfoCreatedAt(NodeTarget target) {
        boolean isCreated = JavaInfoUtils.isCreatedAtTarget(this.m_javaInfo, target);
        if (!isCreated) {
            Assert.fail((String)"{0} is not created at {1} in {2}", (Object[])new Object[]{this.m_javaInfo, target, this.m_javaInfo.getEditor().getSource()});
        }
    }

    protected final boolean isVisibleAtTarget(NodeTarget nodeTarget) {
        StatementTarget target = nodeTarget.getStatementTarget();
        if (target != null) {
            Statement statement = target.getStatement();
            if (statement != null) {
                if (target.isBefore()) {
                    return this.isVisible_before(statement);
                }
                return this.isVisible_after(statement);
            }
            Block block = target.getBlock();
            if (target.isBefore()) {
                return this.isVisible_before((Statement)block);
            }
            return this.isVisible_end(block);
        }
        return false;
    }

    private boolean isVisible_before(Statement statement) {
        if (this.isVisible_isLocalVariable_outsideOfItsBlock(statement)) {
            return false;
        }
        return AbstractSimpleVariableSupport.areInSuchOrderInBlock((ASTNode)this.m_variable, (ASTNode)statement, false);
    }

    private boolean isVisible_after(Statement statement) {
        if (this.isVisible_isLocalVariable_outsideOfItsBlock(statement)) {
            return false;
        }
        if (AbstractSimpleVariableSupport.areInSuchOrderInBlock((ASTNode)this.m_variable, (ASTNode)statement, true)) {
            return !this.isVisible_isReuseVariable_reassignedLater(statement);
        }
        return false;
    }

    private boolean isVisible_end(Block block) {
        if (AstNodeUtils.contains((ASTNode)block, (ASTNode)this.m_variable)) {
            return !this.isVisible_isReuseVariable_reassignedLater((Statement)block);
        }
        return this.isVisible_after((Statement)block);
    }

    private boolean isVisible_isLocalVariable_outsideOfItsBlock(Statement statement) {
        if (!this.getClass().getName().contains(".Local")) {
            return false;
        }
        Block declarationBlock = AstNodeUtils.getEnclosingBlock((ASTNode)this.m_declaration);
        return !AstNodeUtils.contains((ASTNode)declarationBlock, (ASTNode)statement);
    }

    private boolean isVisible_isReuseVariable_reassignedLater(Statement statement) {
        if (!this.getClass().getName().contains("Reuse")) {
            return false;
        }
        List<Expression> allAssignments = ExecutionFlowUtils.getAssignments(this.getFlowDescription(), (ASTNode)this.m_variable);
        for (ASTNode aSTNode : allAssignments) {
            if (AstNodeUtils.contains(aSTNode, (ASTNode)this.m_variable) || !AbstractSimpleVariableSupport.areInSuchOrderInBlock(aSTNode, (ASTNode)statement, true)) continue;
            return true;
        }
        return false;
    }

    private static boolean areInSuchOrderInBlock(ASTNode node_1, ASTNode node_2, boolean equals) {
        Block commonBlock = AstNodeUtils.getCommonBlock(node_1, node_2);
        if (commonBlock != null) {
            Statement statement_1 = AstNodeUtils.getStatementWithinBlock(commonBlock, node_1);
            Statement statement_2 = AstNodeUtils.getStatementWithinBlock(commonBlock, node_2);
            int index_1 = DomGenerics.statements(commonBlock).indexOf(statement_1);
            int index_2 = DomGenerics.statements(commonBlock).indexOf(statement_2);
            if (equals) {
                return index_1 <= index_2;
            }
            return index_1 < index_2;
        }
        return false;
    }

    private StatementTarget getAssociationTarget_beforeAssocitation() {
        LinkedList<MethodInvocation> beforeAssociationInvocations = new LinkedList<MethodInvocation>();
        for (ASTNode node : this.m_javaInfo.getRelatedNodes()) {
            MethodInvocation invocation = this.m_javaInfo.getMethodInvocation(node);
            if (invocation == null) continue;
            String signature = AstNodeUtils.getMethodSignature(invocation);
            MethodDescription description = this.m_javaInfo.getDescription().getMethod(signature);
            if (description == null || !this.isBeforeAssociation(description)) continue;
            beforeAssociationInvocations.add(invocation);
        }
        if (!beforeAssociationInvocations.isEmpty()) {
            ExecutionFlowDescription flowDescription = JavaInfoUtils.getState(this.m_javaInfo).getFlowDescription();
            JavaInfoUtils.sortNodesByFlow(flowDescription, false, beforeAssociationInvocations);
            MethodInvocation targetInvocation = (MethodInvocation)beforeAssociationInvocations.getLast();
            Statement targetStatement = AstNodeUtils.getEnclosingStatement((ASTNode)targetInvocation);
            return new StatementTarget(targetStatement, false);
        }
        return null;
    }

    private boolean isBeforeAssociation(MethodDescription description) {
        MethodOrder order = description.getOrder();
        if (order instanceof MethodOrderDefault) {
            order = this.m_javaInfo.getDescription().getDefaultMethodOrder();
        }
        return order instanceof MethodOrderBeforeAssociation;
    }

    protected final void add_setVariableAndInitializer(Expression variable, Expression initializer) throws Exception {
        this.m_variable = variable;
        this.rememberDeclaration();
        if (AstNodeUtils.getTypeBinding(initializer) == null) {
            throw new DesignerException(207, new Object[]{this.m_javaInfo.getEditor().getSource((ASTNode)initializer)});
        }
        this.m_javaInfo.addRelatedNode((ASTNode)initializer);
        this.m_javaInfo.getCreationSupport().add_setSourceExpression(initializer);
        this.add_setVariableParameterizedType(initializer);
        this.m_javaInfo.addBroadcastListener(new JavaEventListener(){

            @Override
            public void addAfter(JavaInfo parent, JavaInfo child) throws Exception {
                if (child == AbstractSimpleVariableSupport.this.m_javaInfo) {
                    AbstractSimpleVariableSupport.this.m_javaInfo.removeBroadcastListener(this);
                    AbstractSimpleVariableSupport.this.m_javaInfo.getBroadcastJava().variable_setName(AbstractSimpleVariableSupport.this.m_this, null, AbstractSimpleVariableSupport.this.getName());
                }
            }
        });
    }

    protected void add_setVariableParameterizedType(Expression initializer) throws Exception {
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(initializer);
        if (typeBinding.isAnonymous()) {
            typeBinding = typeBinding.getSuperclass();
        }
        if (typeBinding.isParameterizedType()) {
            AstEditor editor = this.m_javaInfo.getEditor();
            String genericTypeName = editor.getTypeBindingSource(typeBinding);
            editor.replaceVariableType(this.m_declaration, genericTypeName);
        }
    }

    protected final void moveStatements(StatementTarget target) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        Statement[] statementsToMove = this.getStatementsToMove(target);
        this.ensureUniqueVariablesDuringMove(target.getPosition(), statementsToMove);
        Statement[] statementArray = statementsToMove;
        int n = statementsToMove.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            editor.moveStatement(statement, target);
            target = new StatementTarget(statement, false);
            ++n2;
        }
    }

    private void ensureUniqueVariablesDuringMove(final int position, final Statement[] statementsToMove) throws Exception {
        this.m_javaInfo.accept(new ObjectInfoVisitor(){

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                JavaInfo javaInfo;
                if (objectInfo instanceof JavaInfo && (javaInfo = (JavaInfo)objectInfo).getVariableSupport() instanceof LocalVariableSupport) {
                    LocalVariableSupport variableSupport = (LocalVariableSupport)javaInfo.getVariableSupport();
                    variableSupport.ensureUniqueVariableDuringMove(position, statementsToMove);
                }
            }
        });
    }

    private Statement[] getStatementsToMove(StatementTarget target) throws Exception {
        HashSet<Statement> statementSet = new HashSet<Statement>();
        AbstractSimpleVariableSupport.addStatementsToMove(statementSet, target, this.m_javaInfo);
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Statement statement : statementSet) {
            Block block = AstNodeUtils.getEnclosingBlock((ASTNode)statement);
            if (blocks.contains(block)) continue;
            blocks.add(block);
        }
        Collections.sort(blocks, AstNodeUtils.SORT_BY_REVERSE_POSITION);
        for (Block block : blocks) {
            List<Statement> blockStatements = DomGenerics.statements(block);
            if (!statementSet.containsAll(blockStatements) || !(block.getParent() instanceof Block)) continue;
            statementSet.removeAll(blockStatements);
            statementSet.add((Statement)block);
        }
        Statement[] statements = statementSet.toArray(new Statement[statementSet.size()]);
        Arrays.sort(statements, AstNodeUtils.SORT_BY_POSITION);
        return statements;
    }

    private static void addStatementsToMove(Set<Statement> statements, StatementTarget target, JavaInfo javaInfo) throws Exception {
        for (ASTNode relatedNode : javaInfo.getRelatedNodes()) {
            Statement statement = AstNodeUtils.getEnclosingStatement(relatedNode);
            if (!AbstractSimpleVariableSupport.canMoveStatement(target, javaInfo, statement) || statement == null) continue;
            statements.add(statement);
        }
        ArrayList<JavaInfo> children = new ArrayList<JavaInfo>(javaInfo.getChildrenJava());
        javaInfo.getBroadcastJava().variable_addStatementsToMove(javaInfo, children);
        for (JavaInfo child : children) {
            AbstractSimpleVariableSupport.addStatementsToMove(statements, target, child);
        }
    }

    private static boolean canMoveStatement(StatementTarget target, JavaInfo javaInfo, Statement statement) {
        ASTNode creationNode;
        MethodDeclaration creationMethod;
        MethodDeclaration statementMethod = AstNodeUtils.getEnclosingMethod((ASTNode)statement);
        if (statementMethod == (creationMethod = AstNodeUtils.getEnclosingMethod(creationNode = javaInfo.getCreationSupport().getNode()))) {
            return true;
        }
        MethodDeclaration targetMethod = AstNodeUtils.getEnclosingMethod(target.getNode());
        return targetMethod == null || statementMethod == targetMethod;
    }

    public abstract void setType(String var1) throws Exception;

    private void hookTextRenameEvent() {
        this.m_javaInfo.addBroadcastListener(new GenericPropertySetValue(){

            @Override
            public void invoke(GenericPropertyImpl property, Object[] value, boolean[] shouldSetValue) throws Exception {
                GenericPropertyDescription description;
                if (property.getJavaInfo().getVariableSupport() == AbstractSimpleVariableSupport.this.m_this && value[0] instanceof String && (description = property.getDescription()) != null && description.hasTrueTag("isText")) {
                    NamesManager.renameForText(AbstractSimpleVariableSupport.this.m_this, property, (String)value[0]);
                }
            }
        });
    }

    String decorateTextName(String newName) {
        return newName;
    }

    protected final FieldDeclaration addField(String fieldSource) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        TypeDeclaration targetType = this.getTypeDeclaration();
        boolean addFieldBefore = true;
        FieldDeclaration targetField = null;
        for (BodyDeclaration bodyDeclaration : DomGenerics.bodyDeclarations(targetType)) {
            if (!(bodyDeclaration instanceof FieldDeclaration)) continue;
            targetField = (FieldDeclaration)bodyDeclaration;
            addFieldBefore = false;
        }
        BodyDeclarationTarget target = new BodyDeclarationTarget(targetType, (BodyDeclaration)targetField, addFieldBefore);
        return editor.addFieldDeclaration(fieldSource, target);
    }
}

