/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.DebugEventListener;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.TabDebugEventListener;
import org.eclipse.wst.jsdt.chromium.internal.BaseCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.websocket.WsConnection;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandCallback;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipTabImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.WipParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipEvent;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipEventType;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.BreakpointResolvedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.PausedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.ResumedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.ScriptParsedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.page.FrameDetachedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.page.FrameNavigatedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParamsWithResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipRequest;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.json.simple.JSONObject;

class WipCommandProcessor {
    private static final Logger LOGGER = Logger.getLogger(WipCommandProcessor.class.getName());
    private final WipTabImpl tabImpl;
    private final BaseCommandProcessor<Integer, JSONObject, JSONObject, WipCommandResponse> baseProcessor;
    private final AtomicInteger currentSeq = new AtomicInteger(0);
    private static final EventMap EVENT_MAP = new EventMap();

    static {
        EVENT_MAP.add(PausedEventData.TYPE, new EventHandler<PausedEventData>(){

            @Override
            void accept(PausedEventData data, WipCommandProcessor commandProcessor) {
                commandProcessor.tabImpl.getContextBuilder().createContext(data);
            }
        });
        EVENT_MAP.add(ResumedEventData.TYPE, new EventHandler<ResumedEventData>(){

            @Override
            void accept(ResumedEventData event, WipCommandProcessor commandProcessor) {
                commandProcessor.tabImpl.getContextBuilder().onResumeReportedFromRemote(event);
            }
        });
        EVENT_MAP.add(ScriptParsedEventData.TYPE, new EventHandler<ScriptParsedEventData>(){

            @Override
            void accept(ScriptParsedEventData eventData, WipCommandProcessor commandProcessor) {
                commandProcessor.tabImpl.getScriptManager().scriptIsReportedParsed(eventData);
            }
        });
        EVENT_MAP.add(BreakpointResolvedEventData.TYPE, new EventHandler<BreakpointResolvedEventData>(){

            @Override
            void accept(BreakpointResolvedEventData eventData, WipCommandProcessor commandProcessor) {
                commandProcessor.tabImpl.getBreakpointManager().breakpointReportedResolved(eventData);
            }
        });
        EVENT_MAP.add(FrameNavigatedEventData.TYPE, new EventHandler<FrameNavigatedEventData>(){

            @Override
            void accept(FrameNavigatedEventData eventData, WipCommandProcessor commandProcessor) {
                commandProcessor.tabImpl.getFrameManager().frameNavigated(eventData);
            }
        });
        EVENT_MAP.add(FrameDetachedEventData.TYPE, null);
    }

    WipCommandProcessor(WipTabImpl tabImpl, WsConnection wsSocket) {
        this.tabImpl = tabImpl;
        WipMessageTypeHandler handler = new WipMessageTypeHandler();
        this.baseProcessor = new BaseCommandProcessor((BaseCommandProcessor.Handler)handler);
    }

    RelayOk sendRaw(JSONObject message, WipCommandCallback callback, SyncCallback syncCallback) {
        return this.baseProcessor.send((Object)message, false, (BaseCommandProcessor.Callback)callback, syncCallback);
    }

    RelayOk send(WipParams params, WipCommandCallback callback, SyncCallback syncCallback) {
        WipRequest request = new WipRequest(params);
        return this.sendRaw(request, callback, syncCallback);
    }

    <RESPONSE> RelayOk send(final WipParamsWithResponse<RESPONSE> params, final GenericCallback<RESPONSE> callback, SyncCallback syncCallback) {
        WipRequest request = new WipRequest(params);
        WipCommandCallback.Default commandCallback = callback == null ? null : new WipCommandCallback.Default(){

            @Override
            protected void onSuccess(WipCommandResponse.Success success) {
                Object response;
                try {
                    response = params.parseResponse(success.data(), WipParserAccess.get());
                }
                catch (JsonProtocolParseException e) {
                    throw new RuntimeException(e);
                }
                callback.success(response);
            }

            @Override
            protected void onError(String message) {
                callback.failure(new Exception(message));
            }
        };
        return this.sendRaw(request, commandCallback, syncCallback);
    }

    void acceptResponse(JSONObject message) {
        this.baseProcessor.processIncoming((Object)message);
    }

    void processEos() {
        this.baseProcessor.processEos();
    }

    private void processEvent(JSONObject jsonObject) {
        WipEvent event;
        try {
            event = WipParserAccess.get().parseWipEvent(jsonObject);
        }
        catch (JsonProtocolParseException e) {
            LOGGER.log(Level.SEVERE, "Failed to parse event", e);
            return;
        }
        EVENT_MAP.handleEvent(event, this);
    }

    public RelayOk runInDispatchThread(Runnable runnable, SyncCallback syncCallback) {
        return this.tabImpl.getWsSocket().runInDispatchThread(runnable, syncCallback);
    }

    private static abstract class EventHandler<T> {
        private EventHandler() {
        }

        abstract void accept(T var1, WipCommandProcessor var2);
    }

    private static class EventMap {
        private final Map<String, InternalHandler<?>> map = new HashMap();

        private EventMap() {
        }

        public <T> void add(WipEventType<T> type, EventHandler<T> eventHandler) {
            InternalHandler<T> internalHandler = new InternalHandler<T>(eventHandler, type);
            this.map.put(type.getMethodName(), internalHandler);
        }

        public void handleEvent(WipEvent event, WipCommandProcessor commandProcessor) {
            String method = event.method();
            InternalHandler<?> parser = this.map.get(method);
            if (parser == null) {
                LOGGER.log(Level.INFO, "Unsupported event: " + method);
                return;
            }
            parser.handle(event, commandProcessor);
        }

        private static class InternalHandler<T> {
            private final EventHandler<T> handler;
            private final WipEventType<T> type;

            InternalHandler(EventHandler<T> handler, WipEventType<T> type) {
                this.handler = handler;
                this.type = type;
            }

            public void handle(WipEvent event, WipCommandProcessor commandProcessor) {
                Object data;
                if (this.handler == null) {
                    return;
                }
                WipEvent.Data genericData = event.data();
                if (genericData == null) {
                    data = null;
                } else {
                    try {
                        data = this.type.parse(WipParserAccess.get(), genericData.getUnderlyingObject());
                    }
                    catch (JsonProtocolParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.handler.accept(data, commandProcessor);
            }
        }
    }

    private class WipMessageTypeHandler
    implements BaseCommandProcessor.Handler<Integer, JSONObject, JSONObject, WipCommandResponse> {
        private WipMessageTypeHandler() {
        }

        public Integer getUpdatedSeq(JSONObject message) {
            Integer seq = WipCommandProcessor.this.currentSeq.addAndGet(1);
            message.put((Object)"id", (Object)seq);
            return seq;
        }

        public String getCommandName(JSONObject message) {
            return (String)message.get((Object)"method");
        }

        public void send(JSONObject message, boolean isImmediate) {
            try {
                WipCommandProcessor.this.tabImpl.getWsSocket().sendTextualMessage(message.toJSONString());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to send", e);
            }
        }

        public WipCommandResponse parseWithSeq(JSONObject incoming) {
            if (!incoming.containsKey((Object)"id")) {
                return null;
            }
            try {
                return WipParserAccess.get().parseWipCommandResponse(incoming);
            }
            catch (JsonProtocolParseException e) {
                throw new RuntimeException("Failed to parse response", e);
            }
        }

        public Integer getSeq(WipCommandResponse incomingWithSeq) {
            Long seqObject = incomingWithSeq.id();
            if (seqObject == null) {
                return null;
            }
            Number number = seqObject;
            return number.intValue();
        }

        public void acceptNonSeq(JSONObject incoming) {
            WipCommandProcessor.this.processEvent(incoming);
        }

        public void reportVmStatus(String currentRequest, int numberOfEnqueued) {
            TabDebugEventListener tabEventListener = WipCommandProcessor.this.tabImpl.getDebugListener();
            DebugEventListener.VmStatusListener vmStatusListener = tabEventListener.getDebugEventListener().getVmStatusListener();
            if (vmStatusListener != null) {
                vmStatusListener.busyStatusChanged(currentRequest, numberOfEnqueued);
            }
        }
    }
}

