/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IType;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;

public class PrefetchModelArchiveJob<M>
extends Job {
    private IType receiverType;
    private IProjectCoordinateProvider pcProvider;
    private IModelProvider<UniqueTypeName, M> modelProvider;

    public PrefetchModelArchiveJob(IType type, IProjectCoordinateProvider pcProvider, IModelProvider<UniqueTypeName, M> modelProvider) {
        super(Messages.JOB_NAME_PREFETCHING_MODEL_ARCHIVE);
        this.receiverType = type;
        this.pcProvider = pcProvider;
        this.modelProvider = modelProvider;
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.MONITOR_NAME_RESOLVING_COORDINATES, -1);
        try {
            try {
                UniqueTypeName name = (UniqueTypeName)this.pcProvider.toUniqueName(this.receiverType).orNull();
                Object model = this.modelProvider.acquireModel((IUniqueName)name).orNull();
                this.modelProvider.releaseModel(model);
            }
            catch (Exception exception) {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

