/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.base.Optional;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.recommenders.utils.LogMessages;
import org.eclipse.recommenders.utils.Logs;

public final class Reflections {
    private Reflections() {
    }

    public static Optional<Class<?>> loadClass(ClassLoader loader, String name) {
        return Reflections.loadClass(false, loader, name);
    }

    public static Optional<Class<?>> loadClass(boolean isFunctionalityLimitedOnFailure, ClassLoader loader, String name) {
        if (loader == null || name == null) {
            return Optional.absent();
        }
        try {
            Class<?> clazz = loader.loadClass(name);
            return Optional.of(clazz);
        }
        catch (ClassNotFoundException e) {
            if (isFunctionalityLimitedOnFailure) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_CLASS_REFLECTIVELY_LIMITED_FUNCTIONALITY, e, name);
            }
            return Optional.absent();
        }
    }

    public static Optional<Field> getDeclaredField(Class<?> declaringClass, String name) {
        return Reflections.getDeclaredField(false, declaringClass, name);
    }

    public static Optional<Field> getDeclaredField(boolean isFunctionalityLimitedOnFailure, Class<?> declaringClass, String name) {
        if (declaringClass == null || name == null) {
            return Optional.absent();
        }
        try {
            Field field = declaringClass.getDeclaredField(name);
            field.setAccessible(true);
            return Optional.of((Object)field);
        }
        catch (NoSuchFieldException e) {
            if (isFunctionalityLimitedOnFailure) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_FIELD_REFLECTIVELY_LIMITED_FUNCTIONALITY, e, name, declaringClass);
            }
            return Optional.absent();
        }
        catch (SecurityException e) {
            if (isFunctionalityLimitedOnFailure) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_FIELD_REFLECTIVELY_LIMITED_FUNCTIONALITY, e, name, declaringClass);
            } else {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_FIELD_REFLECTIVELY, e, name, declaringClass);
            }
            return Optional.absent();
        }
    }

    public static <T> Optional<Constructor<T>> getDeclaredConstructor(Class<T> declaringClass, Class<?> ... parameterTypes) {
        return Reflections.getDeclaredConstructor(false, declaringClass, parameterTypes);
    }

    public static <T> Optional<Constructor<T>> getDeclaredConstructor(boolean isFunctionalityLimitedOnFailure, Class<T> declaringClass, Class<?> ... parameterTypes) {
        if (declaringClass == null || parameterTypes == null) {
            return Optional.absent();
        }
        try {
            Constructor<T> constructor = declaringClass.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return Optional.of(constructor);
        }
        catch (NoSuchMethodException e) {
            if (isFunctionalityLimitedOnFailure) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_CONSTRUCTOR_REFLECTIVELY_LIMITED_FUNCTIONALITY, e, declaringClass);
            }
            return Optional.absent();
        }
        catch (SecurityException e) {
            if (isFunctionalityLimitedOnFailure) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_CONSTRUCTOR_REFLECTIVELY_LIMITED_FUNCTIONALITY, e, declaringClass);
            } else {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_CONSTRUCTOR_REFLECTIVELY, e, declaringClass);
            }
            return Optional.absent();
        }
    }

    public static Optional<Method> getDeclaredMethod(Class<?> declaringClass, String name, Class<?> ... parameterTypes) {
        return Reflections.getDeclaredMethod(false, declaringClass, name, parameterTypes);
    }

    public static Optional<Method> getDeclaredMethod(boolean isFunctionalityLimitedOnFailure, Class<?> declaringClass, String name, Class<?> ... parameterTypes) {
        if (declaringClass == null || name == null || parameterTypes == null) {
            return Optional.absent();
        }
        try {
            Method method = declaringClass.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return Optional.of((Object)method);
        }
        catch (NoSuchMethodException e) {
            if (isFunctionalityLimitedOnFailure) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_METHOD_REFLECTIVELY_LIMITED_FUNCTIONALITY, e, name, declaringClass);
            }
            return Optional.absent();
        }
        catch (SecurityException e) {
            if (isFunctionalityLimitedOnFailure) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_METHOD_REFLECTIVELY_LIMITED_FUNCTIONALITY, e, name, declaringClass);
            } else {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_METHOD_REFLECTIVELY, e, name, declaringClass);
            }
            return Optional.absent();
        }
    }

    public static Optional<Method> getDeclaredMethodWithAlternativeSignatures(Class<?> declaringClass, String name, Class<?>[] ... parameterTypesAlternatives) {
        return Reflections.getDeclaredMethodWithAlternativeSignatures(false, declaringClass, name, parameterTypesAlternatives);
    }

    public static Optional<Method> getDeclaredMethodWithAlternativeSignatures(boolean isFunctionalityLimitedOnFailure, Class<?> declaringClass, String name, Class<?>[] ... parameterTypesAlternatives) {
        if (declaringClass == null || name == null || parameterTypesAlternatives == null) {
            return Optional.absent();
        }
        Class<?>[][] classArray = parameterTypesAlternatives;
        int n = parameterTypesAlternatives.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameterTypesAlternative = classArray[n2];
            Optional<Method> declaredMethod = Reflections.getDeclaredMethod(false, declaringClass, name, parameterTypesAlternative);
            if (declaredMethod.isPresent()) {
                return declaredMethod;
            }
            ++n2;
        }
        if (isFunctionalityLimitedOnFailure) {
            Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_FAILED_TO_ACCESS_METHOD_REFLECTIVELY_LIMITED_FUNCTIONALITY, name, declaringClass);
        }
        return Optional.absent();
    }
}

