/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.validation;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.XGenericType;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XTypeParameter;
import org.eclipse.emf.ecore.xcore.XTypedElement;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.AbstractValidationDiagnostic;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.DiagnosticConverterImpl;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xtext.XtextDiagnosticConverter;

public class XcoreDiagnosticConverter
extends XtextDiagnosticConverter {
    @Inject
    private XcoreMapper mapper;

    protected boolean isEcoreConstraint(Diagnostic diagnostic) {
        return "org.eclipse.emf.ecore.model".equals(diagnostic.getSource());
    }

    protected boolean isEObjectConstraint(Diagnostic diagnostic) {
        return "org.eclipse.emf.ecore".equals(diagnostic.getSource());
    }

    public void convertValidatorDiagnostic(Diagnostic diagnostic, IAcceptor<Issue> acceptor) {
        if (diagnostic.getSeverity() != 0) {
            EObject causer;
            if (this.isEObjectConstraint(diagnostic)) {
                switch (diagnostic.getCode()) {
                    case 1: {
                        List data = diagnostic.getData();
                        if (!data.contains(EcorePackage.Literals.EATTRIBUTE__EATTRIBUTE_TYPE) && !data.contains(EcorePackage.Literals.EREFERENCE__EREFERENCE_TYPE)) break;
                        return;
                    }
                }
            }
            Issue.IssueImpl issue = new Issue.IssueImpl();
            switch (diagnostic.getSeverity()) {
                case 1: {
                    issue.setSeverity(Severity.INFO);
                    break;
                }
                case 2: {
                    issue.setSeverity(Severity.WARNING);
                    break;
                }
                default: {
                    issue.setSeverity(Severity.ERROR);
                }
            }
            DiagnosticConverterImpl.IssueLocation locationData = this.getLocationData(diagnostic);
            if (locationData != null) {
                issue.setLineNumber(locationData.lineNumber);
                issue.setOffset(locationData.offset);
                issue.setLength(locationData.length);
            }
            if ((causer = this.getCauser(diagnostic)) != null) {
                issue.setUriToProblem(EcoreUtil.getURI((EObject)causer));
            }
            if (diagnostic instanceof AbstractValidationDiagnostic) {
                AbstractValidationDiagnostic abstractValidationDiagnostic = (AbstractValidationDiagnostic)diagnostic;
                issue.setType(abstractValidationDiagnostic.getCheckType());
                issue.setCode(abstractValidationDiagnostic.getIssueCode());
                issue.setData(abstractValidationDiagnostic.getIssueData());
            } else {
                issue.setType(CheckType.FAST);
                issue.setCode(String.valueOf(diagnostic.getSource()) + "." + diagnostic.getCode());
            }
            issue.setMessage(diagnostic.getMessage());
            acceptor.accept((Object)issue);
        }
    }

    protected DiagnosticConverterImpl.IssueLocation getLocationData(Diagnostic diagnostic) {
        if (this.isEcoreConstraint(diagnostic)) {
            switch (diagnostic.getCode()) {
                case 6: 
                case 28: {
                    EObject causer = this.getCauser(diagnostic);
                    return this.getLocationData(causer, (EStructuralFeature)XcorePackage.Literals.XTYPED_ELEMENT__MULTIPLICITY);
                }
                case 11: 
                case 12: 
                case 14: {
                    EObject causer = this.getCauser(diagnostic);
                    return this.getLocationData(causer, (EStructuralFeature)XcorePackage.Literals.XREFERENCE__OPPOSITE);
                }
            }
        }
        return super.getLocationData(diagnostic);
    }

    protected EObject getCauser(EObject eObject) {
        if (eObject instanceof ENamedElement) {
            return this.mapper.getToXcoreMapping(eObject).getXcoreElement();
        }
        if (eObject instanceof EGenericType) {
            EObject eContainer = eObject.eContainer();
            if (eContainer != null) {
                EObject causerContainer = this.getCauser(eContainer);
                EReference eContainmentFeature = eObject.eContainmentFeature();
                if (eContainmentFeature == EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE) {
                    return ((XTypedElement)causerContainer).getType();
                }
                if (eContainmentFeature == EcorePackage.Literals.EOPERATION__EGENERIC_EXCEPTIONS) {
                    return (EObject)((XOperation)causerContainer).getExceptions().get(((EOperation)eContainer).getEGenericExceptions().indexOf((Object)eObject));
                }
                if (eContainmentFeature == EcorePackage.Literals.ECLASS__EGENERIC_SUPER_TYPES) {
                    return (EObject)((XClass)causerContainer).getSuperTypes().get(((EClass)eContainer).getEGenericSuperTypes().indexOf((Object)eObject));
                }
                if (eContainmentFeature == EcorePackage.Literals.EGENERIC_TYPE__ETYPE_ARGUMENTS) {
                    return (EObject)((XGenericType)causerContainer).getTypeArguments().get(((EGenericType)eContainer).getETypeArguments().indexOf((Object)eObject));
                }
                if (eContainmentFeature == EcorePackage.Literals.EGENERIC_TYPE__ELOWER_BOUND) {
                    return ((XGenericType)causerContainer).getLowerBound();
                }
                if (eContainmentFeature == EcorePackage.Literals.EGENERIC_TYPE__EUPPER_BOUND) {
                    return ((XGenericType)causerContainer).getUpperBound();
                }
                if (eContainmentFeature == EcorePackage.Literals.ETYPE_PARAMETER__EBOUNDS) {
                    return (EObject)((XTypeParameter)causerContainer).getBounds().get(((ETypeParameter)eContainer).getEBounds().indexOf((Object)eObject));
                }
            }
            return eObject;
        }
        return eObject;
    }

    protected EObject getCauser(Diagnostic diagnostic) {
        EObject result;
        if (this.isEcoreConstraint(diagnostic)) {
            switch (diagnostic.getCode()) {
                case 29: 
                case 30: 
                case 31: {
                    return this.getCauser((EObject)diagnostic.getData().get(1));
                }
            }
        }
        if ((result = super.getCauser(diagnostic)) != null && result.eClass().getEPackage() == EcorePackage.eINSTANCE) {
            result = this.getCauser(result);
        }
        return result;
    }
}

