/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.gmodel.generator;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainElement;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainMap;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainProperty;
import org.eclipse.fx.ide.gmodel.gModelDSL.GModel;
import org.eclipse.fx.ide.gmodel.generator.Util;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class InterfaceGenerator
implements IGenerator {
    public void doGenerate(Resource input, final IFileSystemAccess fsa) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)input.getContents());
        final GModel root = (GModel)_head;
        String _lastSegment = input.getURI().lastSegment();
        int _length = input.getURI().lastSegment().length();
        int _minus = _length - 5;
        final String name = _lastSegment.substring(0, _minus);
        Consumer<GDomainElement> _function = new Consumer<GDomainElement>(){

            @Override
            public void accept(GDomainElement t) {
                String _replace = root.getName().replace(".", "/");
                String _plus = String.valueOf(_replace) + "/";
                String _name = t.getName();
                String _plus_1 = String.valueOf(_plus) + _name;
                String _plus_2 = String.valueOf(_plus_1) + ".java";
                fsa.generateFile(_plus_2, InterfaceGenerator.this.generateType(t, name, root));
            }
        };
        root.getTypeList().forEach((Consumer)_function);
        String _replace = root.getName().replace(".", "/");
        String _plus = String.valueOf(_replace) + "/";
        String _plus_1 = String.valueOf(_plus) + name;
        String _plus_2 = String.valueOf(_plus_1) + "GModel.java";
        fsa.generateFile(_plus_2, this.generateGmodelAccessor(name, root));
        String _replace_1 = root.getName().replace(".", "/");
        String _plus_3 = String.valueOf(_replace_1) + "/";
        String _plus_4 = String.valueOf(_plus_3) + name;
        String _plus_5 = String.valueOf(_plus_4) + "Base.java";
        fsa.generateFile(_plus_5, this.generateBaseInterface(name, root));
    }

    public CharSequence generateBaseInterface(String name, GModel m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = m.getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public interface ");
        _builder.append(name);
        _builder.append("Base {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGmodelAccessor(String name, GModel m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = m.getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public interface ");
        _builder.append(name);
        _builder.append("GModel {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public static ");
        _builder.append(name, "\t");
        _builder.append("GModel create() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return new ");
        String _name_1 = m.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append(".gson.GsonElementFactory();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public <T extends ");
        _builder.append(name, "\t");
        _builder.append("Base> T createObject(java.io.Reader json);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public <T extends ");
        _builder.append(name, "\t");
        _builder.append("Base> java.util.List<T> createList(java.io.Reader json);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String toString(");
        _builder.append(name, "\t");
        _builder.append("Base o);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public String toString(java.util.List<");
        _builder.append(name, "\t");
        _builder.append("Base> o);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<GDomainElement> _typeList = m.getTypeList();
        for (GDomainElement t : _typeList) {
            _builder.append("\t");
            _builder.append("public ");
            String _name_2 = t.getName();
            _builder.append(_name_2, "\t");
            _builder.append(".Builder ");
            String _name_3 = t.getName();
            _builder.append(_name_3, "\t");
            _builder.append("Builder();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateType(GDomainElement e, String name, GModel m) {
        boolean _notEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = m.getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Set<GDomainElement> superHierarchy = Util.collectHierarchicalList(e.getSuperTypeList());
        _builder.newLineIfNotEmpty();
        _builder.append("public interface ");
        String _name_1 = e.getName();
        _builder.append(_name_1);
        _builder.append(" extends ");
        _builder.append(name);
        _builder.append("Base");
        boolean _isEmpty = e.getSuperTypeList().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append(", ");
            Functions.Function1<GDomainElement, String> _function = new Functions.Function1<GDomainElement, String>(){

                public String apply(GDomainElement v) {
                    return v.getName();
                }
            };
            Functions.Function1<GDomainElement, String> _function_1 = new Functions.Function1<GDomainElement, String>(){

                public String apply(GDomainElement v) {
                    return v.getName();
                }
            };
            String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)IterableExtensions.sortBy(superHierarchy, (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)", ");
            _builder.append(_join);
        }
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        EList<GDomainProperty> _propertyList = e.getPropertyList();
        for (GDomainProperty p : _propertyList) {
            _builder.append("\t");
            _builder.append("public ");
            String _type = InterfaceGenerator.getType(p);
            _builder.append(_type, "\t");
            _builder.append(" ");
            String _type_1 = InterfaceGenerator.getType(p);
            boolean _equals = Objects.equal((Object)_type_1, (Object)"boolean");
            if (_equals) {
                _builder.append("is");
            } else {
                _builder.append("get");
            }
            String _firstUpper = StringExtensions.toFirstUpper((String)p.getName());
            _builder.append(_firstUpper, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        GDomainMap _map = e.getMap();
        boolean bl2 = _notEquals = !Objects.equal((Object)_map, null);
        if (_notEquals) {
            _builder.append("\t");
            _builder.append("public java.util.Map<String,");
            String _plainType = InterfaceGenerator.getPlainType(e.getMap());
            _builder.append(_plainType, "\t");
            _builder.append("> getPropertyMap();");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1<GDomainElement, String> _function_2 = new Functions.Function1<GDomainElement, String>(){

            public String apply(GDomainElement v) {
                return v.getName();
            }
        };
        List _sortBy = IterableExtensions.sortBy(superHierarchy, (Functions.Function1)_function_2);
        for (Object t : _sortBy) {
            EList<GDomainProperty> _propertyList_1 = t.getPropertyList();
            for (GDomainProperty p_1 : _propertyList_1) {
                _builder.append("\t");
                _builder.append("public ");
                String _type_2 = InterfaceGenerator.getType(p_1);
                _builder.append(_type_2, "\t");
                _builder.append(" ");
                String _type_3 = InterfaceGenerator.getType(p_1);
                boolean _equals_1 = Objects.equal((Object)_type_3, (Object)"boolean");
                if (_equals_1) {
                    _builder.append("is");
                } else {
                    _builder.append("get");
                }
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)p_1.getName());
                _builder.append(_firstUpper_1, "\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public interface Builder {");
        _builder.newLine();
        EList<GDomainProperty> _propertyList_2 = e.getPropertyList();
        for (GDomainProperty p_2 : _propertyList_2) {
            boolean _isList = p_2.isList();
            if (_isList) {
                _builder.append("\t\t");
                _builder.append("public Builder ");
                String _name_2 = p_2.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append("(");
                String _type_4 = InterfaceGenerator.getType(p_2);
                _builder.append(_type_4, "\t\t");
                _builder.append(" ");
                String _name_3 = p_2.getName();
                _builder.append(_name_3, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("public Builder append");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)p_2.getName());
                _builder.append(_firstUpper_2, "\t\t");
                _builder.append("(");
                String _plainType_1 = InterfaceGenerator.getPlainType(p_2);
                _builder.append(_plainType_1, "\t\t");
                _builder.append(" ");
                String _name_4 = p_2.getName();
                _builder.append(_name_4, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                String _builtIn = p_2.getBuiltIn();
                boolean _equals_2 = Objects.equal((Object)_builtIn, null);
                if (!_equals_2) continue;
                _builder.append("\t\t");
                _builder.append("public Builder ");
                String _name_5 = p_2.getName();
                _builder.append(_name_5, "\t\t");
                _builder.append("(java.util.function.Function<");
                _builder.append(name, "\t\t");
                _builder.append("GModel,java.util.List<");
                String _plainType_2 = InterfaceGenerator.getPlainType(p_2);
                _builder.append(_plainType_2, "\t\t");
                _builder.append(">> provider);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("public Builder append");
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)p_2.getName());
                _builder.append(_firstUpper_3, "\t\t");
                _builder.append("(java.util.function.Function<");
                String _plainType_3 = InterfaceGenerator.getPlainType(p_2);
                _builder.append(_plainType_3, "\t\t");
                _builder.append(".Builder,");
                String _plainType_4 = InterfaceGenerator.getPlainType(p_2);
                _builder.append(_plainType_4, "\t\t");
                _builder.append("> provider);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("\t\t");
            _builder.append("public Builder ");
            String _name_6 = p_2.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append("(");
            String _type_5 = InterfaceGenerator.getType(p_2);
            _builder.append(_type_5, "\t\t");
            _builder.append(" ");
            String _name_7 = p_2.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1<GDomainElement, String> _function_3 = new Functions.Function1<GDomainElement, String>(){

            public String apply(GDomainElement v) {
                return v.getName();
            }
        };
        List _sortBy_1 = IterableExtensions.sortBy(superHierarchy, (Functions.Function1)_function_3);
        for (GDomainElement t_1 : _sortBy_1) {
            EList<GDomainProperty> _propertyList_3 = t_1.getPropertyList();
            for (GDomainProperty p_3 : _propertyList_3) {
                boolean _isList_1 = p_3.isList();
                if (_isList_1) {
                    _builder.append("\t\t");
                    _builder.append("public Builder ");
                    String _name_8 = p_3.getName();
                    _builder.append(_name_8, "\t\t");
                    _builder.append("(");
                    String _type_6 = InterfaceGenerator.getType(p_3);
                    _builder.append(_type_6, "\t\t");
                    _builder.append(" ");
                    String _name_9 = p_3.getName();
                    _builder.append(_name_9, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("public Builder append");
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)p_3.getName());
                    _builder.append(_firstUpper_4, "\t\t");
                    _builder.append("(");
                    String _plainType_5 = InterfaceGenerator.getPlainType(p_3);
                    _builder.append(_plainType_5, "\t\t");
                    _builder.append(" ");
                    String _name_10 = p_3.getName();
                    _builder.append(_name_10, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    String _builtIn_1 = p_3.getBuiltIn();
                    boolean _equals_3 = Objects.equal((Object)_builtIn_1, null);
                    if (!_equals_3) continue;
                    _builder.append("\t\t");
                    _builder.append("public Builder ");
                    String _name_11 = p_3.getName();
                    _builder.append(_name_11, "\t\t");
                    _builder.append("(java.util.function.Function<");
                    _builder.append(name, "\t\t");
                    _builder.append("GModel,java.util.List<");
                    String _plainType_6 = InterfaceGenerator.getPlainType(p_3);
                    _builder.append(_plainType_6, "\t\t");
                    _builder.append(">> provider);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("public Builder append");
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)p_3.getName());
                    _builder.append(_firstUpper_5, "\t\t");
                    _builder.append("(java.util.function.Function<");
                    String _plainType_7 = InterfaceGenerator.getPlainType(p_3);
                    _builder.append(_plainType_7, "\t\t");
                    _builder.append(".Builder,");
                    String _plainType_8 = InterfaceGenerator.getPlainType(p_3);
                    _builder.append(_plainType_8, "\t\t");
                    _builder.append("> provider);");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t\t");
                _builder.append("public Builder ");
                String _name_12 = p_3.getName();
                _builder.append(_name_12, "\t\t");
                _builder.append("(");
                String _type_7 = InterfaceGenerator.getType(p_3);
                _builder.append(_type_7, "\t\t");
                _builder.append(" ");
                String _name_13 = p_3.getName();
                _builder.append(_name_13, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t");
        _builder.append("public ");
        String _name_14 = e.getName();
        _builder.append(_name_14, "\t\t");
        _builder.append(" build();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static String getType(GDomainProperty p) {
        boolean _isList = p.isList();
        if (_isList) {
            String _plainType = InterfaceGenerator.getPlainType(p);
            String _plus = "java.util.List<" + _plainType;
            return String.valueOf(_plus) + ">";
        }
        return InterfaceGenerator.getPlainType(p);
    }

    public static String getPlainType(GDomainProperty p) {
        String _xifexpression = null;
        String _builtIn = p.getBuiltIn();
        boolean _notEquals = !Objects.equal((Object)_builtIn, null);
        _xifexpression = _notEquals ? Util.toJavaType(p.getBuiltIn()) : p.getRef().getName();
        return _xifexpression;
    }

    public static String getPlainType(GDomainMap p) {
        String _xifexpression = null;
        String _builtIn = p.getBuiltIn();
        boolean _notEquals = !Objects.equal((Object)_builtIn, null);
        _xifexpression = _notEquals ? Util.toJavaType(p.getBuiltIn()) : p.getRef().getName();
        return _xifexpression;
    }
}

