/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.html;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.html.TableUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TableInsertRowCommand
extends DesignerCommand {
    private Element _tableEle;
    private int _rowIndex;
    private boolean _isBefore;
    private TableUtil _tableUtil;

    public TableInsertRowCommand(IHTMLGraphicalViewer viewer, Element table, int index, boolean isBefore) {
        super(CommandResources.getString("TableInsertRowCommand.Label.InsertRow"), viewer);
        this._tableEle = table;
        this._rowIndex = index;
        this._isBefore = isBefore;
        this._tableUtil = new TableUtil(this._tableEle);
    }

    public boolean canExecute() {
        int index;
        Element tr;
        boolean isAffectedByRowSpan;
        if (this._rowIndex < 0 && this._rowIndex != -10) {
            return false;
        }
        ArrayList list = new ArrayList();
        TableUtil.getTrElements(this._tableEle, list);
        if (this._rowIndex > 0 && this._rowIndex < list.size() && (isAffectedByRowSpan = TableUtil.isAffectedByRowSpan(list, tr = (Element)list.get(index = this._rowIndex), index))) {
            return false;
        }
        return super.canExecute();
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._tableEle);
    }

    protected void doExecute() {
        ArrayList list = new ArrayList();
        TableUtil.getTrElements(this._tableEle, list);
        Element insertElement = this.createDefaultElement();
        if (this._rowIndex < list.size()) {
            if (this._rowIndex != -10) {
                Element tr;
                int index = this._rowIndex;
                Element nextTr = tr = (Element)list.get(index);
                if (!this._isBefore) {
                    int parentIndex = index - 1;
                    tr = (Element)list.get(parentIndex);
                }
                if (tr.getParentNode() == nextTr.getParentNode()) {
                    tr.getParentNode().insertBefore(insertElement, nextTr);
                } else {
                    tr.getParentNode().appendChild(insertElement);
                }
            } else {
                this._tableEle.appendChild(insertElement);
            }
        } else {
            int index = this._rowIndex - 1;
            Element tr = (Element)list.get(index);
            tr.getParentNode().insertBefore(insertElement, null);
        }
        this.formatNode(this._tableEle);
    }

    private Element createDefaultElement() {
        Document doc = this._tableEle.getOwnerDocument();
        Element ele = doc.createElement("tr");
        int columnCount = this._tableUtil.getColumnCount();
        if (columnCount < 1) {
            columnCount = 1;
        }
        int i = 0;
        while (i < columnCount) {
            Element td = doc.createElement("td");
            Text node = doc.createTextNode(CommandResources.getString("TableInsertColumnCommand.Text.Default"));
            td.appendChild(node);
            ele.appendChild(td);
            ++i;
        }
        return ele;
    }
}

