/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;

public class XPathServices
extends AbstractServiceProvider {
    private static final String ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S = "Only EClass can be contained into other EClasses not %s";
    private static final String S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S = "%s can't contain directly or indirectly %s";
    private final IReadOnlyQueryEnvironment queryEnvironment;

    public XPathServices(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    @Override
    protected IService getService(Method publicMethod) {
        JavaMethodService result = "ancestors".equals(publicMethod.getName()) ? new AncestorsService(publicMethod, (Object)this) : ("followingSiblings".equals(publicMethod.getName()) ? new FollowingSiblingsService(publicMethod, (Object)this) : ("precedingSiblings".equals(publicMethod.getName()) ? new PrecedingSiblingsService(publicMethod, (Object)this) : ("siblings".equals(publicMethod.getName()) ? new SiblingsService(publicMethod, (Object)this) : new JavaMethodService(publicMethod, this))));
        return result;
    }

    @Documentation(value="Returns a Sequence containing the full set of object's ancestors.", params={@Param(name="self", value="The EObject we seek the ancestors of")}, result="Sequence containing the full set of the receiver's ancestors", examples={@Example(expression="eClass.ancestors()", result="Sequence{parentEPackage, grandParentEPackage}")})
    public List<EObject> ancestors(EObject self) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject container = self.eContainer();
        while (container != null) {
            result.add(container);
            container = container.eContainer();
        }
        return result;
    }

    @Documentation(value="Returns a Sequence containing the set of object's ancestors of the given type.", params={@Param(name="self", value="The EObject we seek the ancestors of"), @Param(name="filter", value="The filtering EClass")}, result="Sequence containing the set of the receiver's ancestors of the given type", examples={@Example(expression="eClass.ancestors(ecore::EPackage)", result="Sequence{parentEPackage, grandParentEPackage}")})
    public List<EObject> ancestors(EObject self, EClass filter) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(filter);
        return this.ancestors(self, filters);
    }

    @Documentation(value="Returns a Sequence containing the set of object's ancestors of any given types.", params={@Param(name="self", value="The EObject we seek the ancestors of"), @Param(name="filters", value="The set of filtering EClasses")}, result="Sequence containing the set of the receiver's ancestors of any given types", examples={@Example(expression="eClass.ancestors({ecore::EPackage | ecore::EClass})", result="Sequence{parentEPackage, grandParentEPackage}")})
    public List<EObject> ancestors(EObject self, Set<EClass> filters) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject container = self.eContainer();
        while (container != null) {
            if (this.eIsInstanceOf(container, filters)) {
                result.add(container);
            }
            container = container.eContainer();
        }
        return result;
    }

    @Documentation(value="Returns a Sequence containing the full set of object's following siblings.", params={@Param(name="self", value="The EObject we seek the following siblings of")}, result="Sequence containing the full set of the receiver's following siblings", examples={@Example(expression="eClass3.followingSiblings()", result="Sequence{eClass4, eClass5}")})
    public List<EObject> followingSiblings(EObject self) {
        Object container = this.getContainer(self);
        List<EObject> result = container != null ? this.getContentsFrom(container, self) : Collections.emptyList();
        return result;
    }

    @Documentation(value="Returns a Sequence containing the set of object's following siblings of the given type.", params={@Param(name="self", value="The EObject we seek the following siblings of"), @Param(name="filter", value="The filtering EClass")}, result="Sequence containing the set of the receiver's following siblings of the given type", examples={@Example(expression="eClass3.followingSiblings(ecore::EClass)", result="Sequence{eClass4, eClass5}")})
    public List<EObject> followingSiblings(EObject self, EClass filter) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(filter);
        return this.followingSiblings(self, filters);
    }

    @Documentation(value="Returns a Sequence containing the set of object's following siblings of any given types.", params={@Param(name="self", value="The EObject we seek the following siblings of"), @Param(name="filters", value="The set of filtering EClasses")}, result="Sequence containing the set of the receiver's following siblings of any given types", examples={@Example(expression="eClass3.followingSiblings({ecore::EPackage | ecore::EClass})", result="Sequence{eClass4, eClass5}")})
    public List<EObject> followingSiblings(EObject eObject, Set<EClass> filters) {
        ArrayList<EObject> result;
        Object container = this.getContainer(eObject);
        if (container instanceof EObject) {
            result = new ArrayList();
            EStructuralFeature containingFeature = eObject.eContainingFeature();
            List<EStructuralFeature> followingFeatures = this.getFollowingFeatures((EObject)container, containingFeature, filters);
            boolean collect = followingFeatures.size() > 0 && followingFeatures.get(0) != containingFeature;
            for (EStructuralFeature feature : followingFeatures) {
                Object value = ((EObject)container).eGet(feature);
                if (value instanceof Collection) {
                    for (Object child : (Collection)value) {
                        if (child == eObject) {
                            collect = true;
                            continue;
                        }
                        if (!collect || !(child instanceof EObject) || !this.eIsInstanceOf((EObject)child, filters)) continue;
                        result.add((EObject)child);
                    }
                    continue;
                }
                if (value == eObject) {
                    collect = true;
                    continue;
                }
                if (!collect || !(value instanceof EObject) || !this.eIsInstanceOf((EObject)value, filters)) continue;
                result.add((EObject)value);
            }
        } else if (container instanceof Resource) {
            result = new ArrayList();
            for (EObject eObj : this.getRootsFrom((Resource)container, eObject)) {
                if (!this.eIsInstanceOf(eObj, filters)) continue;
                result.add(eObj);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<EStructuralFeature> getFollowingFeatures(EObject container, EStructuralFeature containingFeature, Set<EClass> filters) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        LinkedHashSet<EStructuralFeature> filteredFeatures = new LinkedHashSet<EStructuralFeature>();
        for (EClass eCls : filters) {
            filteredFeatures.addAll(this.queryEnvironment.getEPackageProvider().getContainingEStructuralFeatures(eCls));
        }
        EStructuralFeature[] containmentFeatures = ((EClassImpl.FeatureSubsetSupplier)container.eClass().getEAllStructuralFeatures()).containments();
        boolean collect = false;
        EStructuralFeature[] eStructuralFeatureArray = containmentFeatures;
        int n = containmentFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature containmentFeature = eStructuralFeatureArray[n2];
            if (containmentFeature == containingFeature) {
                collect = true;
            }
            if (collect && filteredFeatures.contains(containmentFeature)) {
                result.add(containmentFeature);
            }
            ++n2;
        }
        return result;
    }

    @Documentation(value="Returns a Sequence containing the full set of object's preceding siblings.", params={@Param(name="self", value="The EObject we seek the preceding siblings of")}, result="Sequence containing the full set of the receiver's preceding siblings", examples={@Example(expression="eClass3.precedingSiblings()", result="Sequence{eClass1, eClass2}")})
    public List<EObject> precedingSiblings(EObject self) {
        Object container = this.getContainer(self);
        List<EObject> result = container != null ? this.getContentsUntil(container, self) : Collections.emptyList();
        return result;
    }

    @Documentation(value="Returns a Sequence containing the set of object's preceding siblings of the given type.", params={@Param(name="self", value="The EObject we seek the preceding siblings of"), @Param(name="filter", value="The filtering EClass")}, result="Sequence containing the set of the receiver's preceding siblings of the given type", examples={@Example(expression="eClass3.precedingSiblings(ecore::EClass)", result="Sequence{eClass1, eClass2}")})
    public List<EObject> precedingSiblings(EObject self, EClass filter) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(filter);
        return this.precedingSiblings(self, filters);
    }

    @Documentation(value="Returns a Sequence containing the set of object's preceding siblings of any given types.", params={@Param(name="self", value="The EObject we seek the preceding siblings of"), @Param(name="filters", value="The set of filtering EClasses")}, result="Sequence containing the set of the receiver's preceding siblings of any given types", examples={@Example(expression="eClass3.precedingSiblings({ecore::EPackage | ecore::EClass})", result="Sequence{eClass1, eClass2}")})
    public List<EObject> precedingSiblings(EObject eObject, Set<EClass> filters) {
        ArrayList<EObject> result;
        block10: {
            Object container = this.getContainer(eObject);
            if (container instanceof EObject) {
                result = new ArrayList();
                EStructuralFeature containingFeature = eObject.eContainingFeature();
                List<EStructuralFeature> precedingFeatures = this.getPrecedingFeatures((EObject)container, containingFeature, filters);
                for (EStructuralFeature feature : precedingFeatures) {
                    Object value = ((EObject)container).eGet(feature);
                    if (value instanceof Collection) {
                        for (Object child : (Collection)value) {
                            if (child != eObject) {
                                if (!(child instanceof EObject) || !this.eIsInstanceOf((EObject)child, filters)) continue;
                                result.add((EObject)child);
                                continue;
                            }
                            break block10;
                        }
                        continue;
                    }
                    if (value != eObject) {
                        if (!(value instanceof EObject) || !this.eIsInstanceOf((EObject)value, filters)) continue;
                        result.add((EObject)value);
                        continue;
                    }
                    break;
                }
            } else if (container instanceof Resource) {
                result = new ArrayList();
                for (EObject eObj : this.getRootsUntil((Resource)container, eObject)) {
                    if (!this.eIsInstanceOf(eObj, filters)) continue;
                    result.add(eObj);
                }
            } else {
                result = Collections.emptyList();
            }
        }
        return result;
    }

    private List<EStructuralFeature> getPrecedingFeatures(EObject container, EStructuralFeature containingFeature, Set<EClass> filters) {
        EStructuralFeature[] containmentFeatures;
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        LinkedHashSet<EStructuralFeature> filteredFeatures = new LinkedHashSet<EStructuralFeature>();
        for (EClass eCls : filters) {
            filteredFeatures.addAll(this.queryEnvironment.getEPackageProvider().getContainingEStructuralFeatures(eCls));
        }
        EStructuralFeature[] eStructuralFeatureArray = containmentFeatures = ((EClassImpl.FeatureSubsetSupplier)container.eClass().getEAllStructuralFeatures()).containments();
        int n = containmentFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature containmentFeature = eStructuralFeatureArray[n2];
            if (filteredFeatures.contains(containmentFeature)) {
                result.add(containmentFeature);
            }
            if (containmentFeature == containingFeature) break;
            ++n2;
        }
        return result;
    }

    @Documentation(value="Returns a Sequence containing the full set of object's siblings.", params={@Param(name="self", value="The EObject we seek the siblings of")}, result="Sequence containing the full set of the receiver's siblings", examples={@Example(expression="eClass3.siblings()", result="Sequence{eClass1, eClass2, eClass4, eClass5}")})
    public List<EObject> siblings(EObject self) {
        Object container = this.getContainer(self);
        List<EObject> result = container != null ? this.getContentsExcluding(container, self) : Collections.emptyList();
        return result;
    }

    @Documentation(value="Returns a Sequence containing the set of object's siblings of the given type.", params={@Param(name="self", value="The EObject we seek the siblings of"), @Param(name="filter", value="The filtering EClass")}, result="Sequence containing the set of the receiver's siblings of the given type", examples={@Example(expression="eClass3.siblings(ecore::EClass)", result="Sequence{eClass1, eClass2, eClass4, eClass5}")})
    public List<EObject> siblings(EObject self, EClass filter) {
        LinkedHashSet filters = Sets.newLinkedHashSet();
        filters.add(filter);
        return this.siblings(self, filters);
    }

    @Documentation(value="Returns a Sequence containing the set of object's siblings of any given types.", params={@Param(name="self", value="The EObject we seek the siblings of"), @Param(name="filters", value="The set of filtering EClasses")}, result="Sequence containing the set of the receiver's siblings of any given types", examples={@Example(expression="eClass3.siblings({ecore::EPackage | ecore::EClass})", result="Sequence{eClass1, eClass2, eClass1, eClass2}")})
    public List<EObject> siblings(EObject eObject, Set<EClass> filters) {
        ArrayList<EObject> result;
        Object container = this.getContainer(eObject);
        if (container instanceof EObject) {
            result = new ArrayList();
            EStructuralFeature containingFeature = eObject.eContainingFeature();
            List<EStructuralFeature> features = this.getFeatures((EObject)container, containingFeature, filters);
            for (EStructuralFeature containmentFeature : features) {
                Object value = ((EObject)container).eGet(containmentFeature);
                if (value instanceof Collection) {
                    for (Object child : (Collection)value) {
                        if (child == eObject || !(child instanceof EObject) || !this.eIsInstanceOf((EObject)child, filters)) continue;
                        result.add((EObject)child);
                    }
                    continue;
                }
                if (value == eObject || !(value instanceof EObject) || !this.eIsInstanceOf((EObject)value, filters)) continue;
                result.add((EObject)value);
            }
        } else if (container instanceof Resource) {
            result = new ArrayList();
            for (EObject eObj : this.getRootsExcluding((Resource)container, eObject)) {
                if (!this.eIsInstanceOf(eObj, filters)) continue;
                result.add(eObj);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<EStructuralFeature> getFeatures(EObject container, EStructuralFeature containingFeature, Set<EClass> filters) {
        EStructuralFeature[] containmentFeatures;
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        LinkedHashSet<EStructuralFeature> filteredFeatures = new LinkedHashSet<EStructuralFeature>();
        for (EClass eCls : filters) {
            filteredFeatures.addAll(this.queryEnvironment.getEPackageProvider().getContainingEStructuralFeatures(eCls));
        }
        EStructuralFeature[] eStructuralFeatureArray = containmentFeatures = ((EClassImpl.FeatureSubsetSupplier)container.eClass().getEAllStructuralFeatures()).containments();
        int n = containmentFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature containmentFeature = eStructuralFeatureArray[n2];
            if (filteredFeatures.contains(containmentFeature)) {
                result.add(containmentFeature);
            }
            ++n2;
        }
        return result;
    }

    private Object getContainer(EObject object) {
        EObject result = object.eContainer();
        if (result == null && object instanceof InternalEObject) {
            result = ((InternalEObject)object).eDirectResource();
        }
        return result;
    }

    private List<EObject> getContentsExcluding(Object container, EObject toExclude) {
        List<Object> contents = container instanceof EObject ? this.getContentsExcluding((EObject)container, toExclude) : (container instanceof Resource ? this.getRootsExcluding((Resource)container, toExclude) : Collections.emptyList());
        return contents;
    }

    private List<EObject> getContentsUntil(Object container, EObject until) {
        List<Object> contents = container instanceof EObject ? this.getContentsUntil((EObject)container, until) : (container instanceof Resource ? this.getRootsUntil((Resource)container, until) : Collections.emptyList());
        return contents;
    }

    private List<EObject> getContentsFrom(Object container, EObject from) {
        List<Object> contents = container instanceof EObject ? this.getContentsFrom((EObject)container, from) : (container instanceof Resource ? this.getRootsFrom((Resource)container, from) : Collections.emptyList());
        return contents;
    }

    private List<EObject> getContentsExcluding(EObject container, EObject toExcluse) {
        EStructuralFeature[] containmentFeatures;
        ArrayList<EObject> result = new ArrayList<EObject>();
        EStructuralFeature[] eStructuralFeatureArray = containmentFeatures = ((EClassImpl.FeatureSubsetSupplier)container.eClass().getEAllStructuralFeatures()).containments();
        int n = containmentFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            Object value = container.eGet(feature);
            if (value instanceof Collection) {
                for (Object child : (Collection)value) {
                    if (child == toExcluse || !(child instanceof EObject)) continue;
                    result.add((EObject)child);
                }
            } else if (value != toExcluse && value instanceof EObject) {
                result.add((EObject)value);
            }
            ++n2;
        }
        return result;
    }

    private List<EObject> getContentsUntil(EObject container, EObject until) {
        EStructuralFeature[] containmentFeatures;
        ArrayList<EObject> result = new ArrayList<EObject>();
        EStructuralFeature[] eStructuralFeatureArray = containmentFeatures = ((EClassImpl.FeatureSubsetSupplier)container.eClass().getEAllStructuralFeatures()).containments();
        int n = containmentFeatures.length;
        int n2 = 0;
        block0: while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            Object value = container.eGet(feature);
            if (value instanceof Collection) {
                for (Object child : (Collection)value) {
                    if (child == until) break block0;
                    if (!(child instanceof EObject)) continue;
                    result.add((EObject)child);
                }
            } else {
                if (value == until) break;
                if (value instanceof EObject) {
                    result.add((EObject)value);
                }
            }
            ++n2;
        }
        return result;
    }

    private List<EObject> getContentsFrom(EObject container, EObject until) {
        EStructuralFeature[] containmentFeatures;
        ArrayList<EObject> result = new ArrayList<EObject>();
        boolean collect = false;
        EStructuralFeature[] eStructuralFeatureArray = containmentFeatures = ((EClassImpl.FeatureSubsetSupplier)container.eClass().getEAllStructuralFeatures()).containments();
        int n = containmentFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            Object value = container.eGet(feature);
            if (value instanceof Collection) {
                for (Object child : (Collection)value) {
                    if (child == until) {
                        collect = true;
                        continue;
                    }
                    if (!collect || !(child instanceof EObject)) continue;
                    result.add((EObject)child);
                }
            } else if (value == until) {
                collect = true;
            } else if (collect && value instanceof EObject) {
                result.add((EObject)value);
            }
            ++n2;
        }
        return result;
    }

    private List<EObject> getRootsExcluding(Resource resource, EObject toExclude) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject eObj : resource.getContents()) {
            if (eObj == toExclude || eObj.eContainer() != null) continue;
            result.add(eObj);
        }
        return result;
    }

    private List<EObject> getRootsUntil(Resource resource, EObject until) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject eObj : resource.getContents()) {
            if (eObj == until) break;
            if (eObj.eContainer() != null) continue;
            result.add(eObj);
        }
        return result;
    }

    private List<EObject> getRootsFrom(Resource resource, EObject from) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        boolean collect = false;
        for (EObject eObj : resource.getContents()) {
            if (eObj == from) {
                collect = true;
                continue;
            }
            if (!collect || eObj.eContainer() != null) continue;
            result.add(eObj);
        }
        return result;
    }

    private static void addEObjectEClass(Set<IType> types, IReadOnlyQueryEnvironment queryEnvironment) {
        for (EClassifier classifier : queryEnvironment.getEPackageProvider().getTypes("ecore", "EObject")) {
            types.add(new EClassifierType(queryEnvironment, classifier));
        }
    }

    private boolean eIsInstanceOf(EObject value, Set<EClass> types) {
        for (EClass type : types) {
            if (!type.isSuperTypeOf(value.eClass()) && !type.isInstance((Object)value)) continue;
            return true;
        }
        return false;
    }

    private static final class AncestorsService
    extends FilterService {
        private AncestorsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                        for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClassifier)));
                        }
                    } else if (argTypes.size() == 2) {
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing(XPathServices.ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S, argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)containingEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't be contained", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    XPathServices.addEObjectEClass(filterTypes, queryEnvironment);
                }
                for (IType filterType : filterTypes) {
                    for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containingEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing(XPathServices.S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S, argTypes.get(1), argTypes.get(0))));
                }
            }
            return result;
        }
    }

    private static final class FollowingSiblingsService
    extends FilterService {
        private FollowingSiblingsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                        for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClassifier)));
                        }
                    } else if (argTypes.size() == 2) {
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can have following siblings not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass followingEClass : queryEnvironment.getEPackageProvider().getFollowingSiblingsEClasses(receiverEClass)) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)followingEClass)));
                }
                result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject())));
            } else if (argTypes.size() == 2) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    XPathServices.addEObjectEClass(filterTypes, queryEnvironment);
                }
                for (IType filterType : filterTypes) {
                    for (EClass followingEClass : queryEnvironment.getEPackageProvider().getFollowingSiblingsEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)followingEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                    result.add(new SequenceType(queryEnvironment, services.lower(filterType, filterType)));
                }
            }
            return result;
        }
    }

    private static final class PrecedingSiblingsService
    extends FilterService {
        private PrecedingSiblingsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                        for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClassifier)));
                        }
                    } else if (argTypes.size() == 2) {
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can have preceding siblings not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass precedingEClass : queryEnvironment.getEPackageProvider().getPrecedingSiblingsEClasses(receiverEClass)) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)precedingEClass)));
                }
                result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject())));
            } else if (argTypes.size() == 2) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    XPathServices.addEObjectEClass(filterTypes, queryEnvironment);
                }
                for (IType filterType : filterTypes) {
                    for (EClass precedingEClass : queryEnvironment.getEPackageProvider().getPrecedingSiblingsEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)precedingEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                    result.add(new SequenceType(queryEnvironment, services.lower(filterType, filterType)));
                }
            }
            return result;
        }
    }

    private static final class SiblingsService
    extends FilterService {
        private SiblingsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                        for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClassifier)));
                        }
                    } else if (argTypes.size() == 2) {
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can have siblings not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass siblingEClass : queryEnvironment.getEPackageProvider().getSiblingsEClasses(receiverEClass)) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)siblingEClass)));
                }
                result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject())));
            } else if (argTypes.size() == 2) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    XPathServices.addEObjectEClass(filterTypes, queryEnvironment);
                }
                for (IType filterType : filterTypes) {
                    for (EClass siblingEClass : queryEnvironment.getEPackageProvider().getSiblingsEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)siblingEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                    result.add(new SequenceType(queryEnvironment, services.lower(filterType, filterType)));
                }
            }
            return result;
        }
    }
}

