/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import org.eclipse.actf.util.win32.IIntervalExec;
import org.eclipse.actf.util.win32.OverlayLabel;
import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OverlayWindow
implements Runnable {
    public static final String WINDOW_TEXT = "[Overlay Window]";
    public static final int INDEX_HIGHLIGHT = 0;
    public static final int INDEX_LABELS = 1;
    private static boolean visible = true;
    private Shell shell = new Shell(16392);
    private Display display;
    private static OverlayWindow[] instance = new OverlayWindow[2];

    private OverlayWindow(int n) {
        this.shell.setText(WINDOW_TEXT);
        this.shell.setBackground(this.shell.getBackground());
        this.display = this.shell.getDisplay();
        Shell shell = this.display.getActiveShell();
        if (shell != null) {
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    OverlayWindow.this.shell.dispose();
                }
            });
        }
        OverlayWindow.setLayered((Control)this.shell, n == 0);
        this.shell.setLayout((Layout)new GridLayout());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        this.shell.setBounds(0, 0, rectangle.width, rectangle.height);
        this.shell.setVisible(visible);
        if (1 == n) {
            this.shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellDeactivated(ShellEvent shellEvent) {
                    OverlayLabel.removeAll();
                }
            });
        }
    }

    public static OverlayWindow getInstance(int n, boolean bl) {
        if (n < instance.length) {
            if (bl && (instance[n] == null || instance[n].getComposite().isDisposed())) {
                OverlayWindow.instance[n] = new OverlayWindow(n);
            }
            return instance[n];
        }
        return null;
    }

    public static boolean getVisible() {
        return visible;
    }

    public static void setVisible(boolean bl) {
        if (visible != bl) {
            visible = bl;
            int n = 0;
            while (n < instance.length) {
                if (instance[n] != null) {
                    OverlayWindow.instance[n].shell.setVisible(visible);
                }
                ++n;
            }
        }
    }

    public Composite getComposite() {
        return this.shell;
    }

    public void run() {
        if (!this.shell.isDisposed()) {
            Control[] controlArray = this.shell.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                int n2;
                if (controlArray[n] instanceof IIntervalExec && (n2 = ((IIntervalExec)controlArray[n]).exec()) > 0) {
                    this.display.timerExec(n2, (Runnable)this);
                }
                ++n;
            }
        }
    }

    private static void setLayered(Control control, boolean bl) {
        int n = OS.GetWindowLongW((int)control.handle, (int)-20);
        n |= 0x80000;
        if (bl) {
            n |= 0x20;
        }
        OS.SetWindowLong((int)control.handle, (int)-20, (int)n);
        WindowUtil.SetLayeredWindowAttributes(control.handle, control.getBackground().handle, '\u0000', 1);
    }
}

