/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.core.runtime.CoreException;

public class IndexToASTNameHelper {
    public static List<IASTName> findNamesIn(IASTTranslationUnit tu, IBinding binding, IIndex index) {
        BindingToAstNameMatcher visitor = new BindingToAstNameMatcher(binding, index);
        tu.accept((ASTVisitor)visitor);
        return visitor.getMatches();
    }

    public static IASTName findMatchingASTName(IASTTranslationUnit tu, IName name, IIndex index) throws CoreException {
        if (name instanceof IASTName) {
            return (IASTName)name;
        }
        if (!(name instanceof IIndexName)) {
            return null;
        }
        IndexNameToAstNameMatcher visitor = new IndexNameToAstNameMatcher(tu, (IIndexName)name, index);
        tu.accept((ASTVisitor)visitor);
        return visitor.getMatch();
    }

    static boolean shouldConsiderName(IASTName candidate) {
        return !IndexToASTNameHelper.isQualifiedName(candidate) && IndexToASTNameHelper.isLastNameInQualifiedName(candidate) && !IndexToASTNameHelper.isUnnamedName(candidate);
    }

    private static boolean isLastNameInQualifiedName(IASTName name) {
        if (name.getParent() instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qName = (ICPPASTQualifiedName)name.getParent();
            return name.equals(qName.getLastName());
        }
        return true;
    }

    private static boolean isUnnamedName(IASTName name) {
        return name.getFileLocation() == null && name.toCharArray().length == 0;
    }

    private static boolean isQualifiedName(IASTName name) {
        return name instanceof ICPPASTQualifiedName;
    }

    private static class BindingToAstNameMatcher
    extends ASTVisitor {
        private List<IASTName> results = new ArrayList<IASTName>();
        private IBinding bindingToFind;
        private char[] toFindName;
        private IIndex index;

        public BindingToAstNameMatcher(IBinding binding, IIndex index) {
            super(true);
            this.bindingToFind = index.adaptBinding(binding);
            this.index = index;
            this.toFindName = binding.getNameCharArray();
            this.shouldVisitImplicitNames = true;
            this.shouldVisitImplicitNameAlternates = true;
        }

        public int visit(IASTName candidate) {
            if (!IndexToASTNameHelper.shouldConsiderName(candidate)) {
                return 3;
            }
            if (this.isEquivalent(candidate)) {
                this.results.add(candidate);
            }
            return 3;
        }

        private boolean isEquivalent(IASTName candidate) {
            return CharArrayUtils.equals((char[])candidate.getSimpleID(), (char[])this.toFindName) && this.bindingToFind.equals(this.index.adaptBinding(candidate.resolveBinding()));
        }

        public List<IASTName> getMatches() {
            return this.results;
        }
    }

    private static class IndexNameToAstNameMatcher
    extends ASTVisitor {
        private IASTName result;
        private IBinding bindingToFind;
        private char[] charNameToFind;
        private IIndex index;
        private IASTFileLocation locationToFind;

        public IndexNameToAstNameMatcher(IASTTranslationUnit tu, IIndexName indexName, IIndex index) throws CoreException {
            super(true);
            this.locationToFind = indexName.getFileLocation();
            this.bindingToFind = index.findBinding((IName)indexName);
            this.index = index;
            this.charNameToFind = this.bindingToFind.getNameCharArray();
            this.shouldVisitImplicitNames = true;
            this.shouldVisitImplicitNameAlternates = true;
        }

        public int visit(IASTName candidate) {
            if (!IndexToASTNameHelper.shouldConsiderName(candidate)) {
                return 3;
            }
            if (this.isEquivalent(candidate)) {
                this.result = candidate;
                return 2;
            }
            return 3;
        }

        private boolean isEquivalent(IASTName candidate) {
            return this.matchesIndexName(candidate) && this.bindingToFind.equals(this.index.adaptBinding(candidate.resolveBinding()));
        }

        private boolean matchesIndexName(IASTName candidate) {
            IASTFileLocation candidateLocation = candidate.getFileLocation();
            return this.locationToFind.getNodeOffset() == candidateLocation.getNodeOffset() && this.locationToFind.getNodeLength() == candidateLocation.getNodeLength() && this.locationToFind.getFileName().equals(candidateLocation.getFileName()) && CharArrayUtils.equals((char[])candidate.getSimpleID(), (char[])this.charNameToFind);
        }

        public IASTName getMatch() {
            return this.result;
        }
    }
}

